/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.service.workflows;

import fr.toutatice.ecm.platform.core.helper.ToutaticeWorkflowHelper;
import fr.toutatice.ecm.platform.service.workflows.ToutaticeWorkflowService;
import fr.toutatice.ecm.platform.service.workflows.WorkflowDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ToutaticeWorkflowServiceImpl
extends DefaultComponent
implements ToutaticeWorkflowService {
    protected static final String WF_EXT_POINT = "workflows";
    private Map<String, List<String>> wfContribs;

    @Override
    public boolean hasContributions() {
        return MapUtils.isEmpty(this.wfContribs);
    }

    public void setWfContribs(Map<String, List<String>> wfContribs) {
        this.wfContribs = wfContribs;
    }

    public void activate(ComponentContext context) throws Exception {
        super.activate(context);
        this.wfContribs = new HashMap<String, List<String>>(0);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        String wfName;
        WorkflowDescriptor wfDesc;
        String wfCategory;
        if (WF_EXT_POINT.equals(extensionPoint) && StringUtils.isNotBlank((String)(wfCategory = (wfDesc = (WorkflowDescriptor)contribution).getWfCategory())) && StringUtils.isNotBlank((String)(wfName = wfDesc.getWfName()))) {
            if (!this.wfContribs.containsKey(wfCategory)) {
                ArrayList<String> wfNames = new ArrayList<String>(1);
                wfNames.add(wfName);
                this.wfContribs.put(wfCategory, wfNames);
            } else {
                List<String> wfNames = this.wfContribs.get(wfCategory);
                wfNames.add(wfName);
                this.wfContribs.put(wfCategory, wfNames);
            }
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        String wfName;
        WorkflowDescriptor wfDesc;
        String wfCategory;
        if (WF_EXT_POINT.equals(extensionPoint) && StringUtils.isNotBlank((String)(wfCategory = (wfDesc = (WorkflowDescriptor)contribution).getWfCategory())) && StringUtils.isNotBlank((String)(wfName = wfDesc.getWfName()))) {
            List<String> wfNames = this.wfContribs.get(wfCategory);
            wfNames.remove(wfName);
            this.wfContribs.put(wfCategory, wfNames);
        }
    }

    public List<String> getWfnamesByCategory(String category) {
        List<String> wfNames = this.wfContribs.get(category);
        if (CollectionUtils.isEmpty(wfNames)) {
            wfNames = new ArrayList<String>(0);
        }
        return wfNames;
    }

    @Override
    public boolean isWorkflowOfCategoryRunning(String category, DocumentModel document) {
        boolean running = false;
        List<String> wfNames = this.getWfnamesByCategory(category);
        Iterator<String> it = wfNames.iterator();
        while (it.hasNext() && !running) {
            String wfName = it.next();
            DocumentRoute workflow = ToutaticeWorkflowHelper.getWorkflowByName((String)wfName, (DocumentModel)document);
            running = workflow != null;
        }
        return running;
    }
}

