/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.service.workflows.infos;

import fr.toutatice.ecm.platform.core.helper.ToutaticeWorkflowHelper;
import fr.toutatice.ecm.platform.core.services.infos.provider.DocumentInformationsProvider;
import fr.toutatice.ecm.platform.service.workflows.ToutaticeTaskService;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.runtime.api.Framework;

public class TaskDocumentInfosProvider
implements DocumentInformationsProvider {
    private ToutaticeTaskService taskSrv = (ToutaticeTaskService)Framework.getService(ToutaticeTaskService.class);

    public Map<String, Object> fetchInfos(CoreSession coreSession, DocumentModel currentDocument) throws ClientException {
        HashMap<String, Object> infos = new HashMap<String, Object>(0);
        if (!currentDocument.isFolder() && this.taskSrv.hasContributions()) {
            Task currentTask = null;
            boolean taskFound = false;
            String searchedTaskName = "";
            String permission = null;
            Set<String> tasksNames = this.taskSrv.getTaskContributions().keySet();
            Iterator<String> iterator = tasksNames.iterator();
            while (iterator.hasNext() && !taskFound) {
                String taskName = iterator.next();
                Task task = this.getTask(coreSession, currentDocument, taskName);
                if (task == null) continue;
                searchedTaskName = taskName;
                currentTask = task;
                permission = this.taskSrv.getTaskContributions().get(taskName);
                taskFound = true;
            }
            infos.put(TaskInfos.taskName.name(), searchedTaskName);
            infos.put(TaskInfos.isTaskPending.name(), this.taskSrv.isTaskPending(currentTask));
            infos.put(TaskInfos.isTaskInitiator.name(), this.taskSrv.isUserTaskInitiator(coreSession, currentTask));
            infos.put(TaskInfos.canManageTask.name(), this.taskSrv.canUserManageTask(coreSession, currentTask, currentDocument, permission));
        }
        return infos;
    }

    protected Task getTask(CoreSession coreSession, DocumentModel document, String taskName) {
        return ToutaticeWorkflowHelper.getTaskByName((String)taskName, (CoreSession)coreSession, (DocumentModel)document);
    }

    private static enum TaskInfos {
        taskName,
        isTaskPending,
        canManageTask,
        isTaskInitiator;

    }
}

