/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.schema.CustomizeTypesService;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.DocumentTypeDescriptor;
import org.nuxeo.ecm.core.schema.DocumentTypeImpl;
import org.nuxeo.ecm.core.schema.RulesDescriptor;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.SchemaManagerImpl;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class CustomizeTypesServiceImpl
extends DefaultComponent
implements CustomizeTypesService {
    private static final long serialVersionUID = -3335398967270359400L;
    private static final Log log = LogFactory.getLog(CustomizeTypesService.class);
    public static final String BASE_TYPE_EXT_POINT = "basettc";
    public static final String EXCLUDED_RULES_EXT_POINT = "excludedrules";
    public static final String DOC_TYPE_EXT_POINT = "doctype";
    public static final String TYPES_RULE = "types";
    public static final String FACETS_RULE = "facets";
    private Map<String, List<String>> excludedRules;
    private List<String> allExcludedTypes = new ArrayList<String>();
    private SchemaManager schemaManager;
    private DocumentTypeDescriptor baseDocTypeDescriptor;

    public void activate(ComponentContext context) throws Exception {
        super.activate(context);
        this.schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        this.excludedRules = new HashMap<String, List<String>>(0);
    }

    public int getApplicationStartedOrder() {
        return 90;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (EXCLUDED_RULES_EXT_POINT.equals(extensionPoint)) {
            RulesDescriptor rulesDescriptor = (RulesDescriptor)contribution;
            this.setExcludedRules(rulesDescriptor);
        }
        if (BASE_TYPE_EXT_POINT.equals(extensionPoint)) {
            if (this.baseDocTypeDescriptor == null) {
                this.baseDocTypeDescriptor = (DocumentTypeDescriptor)contribution;
            } else {
                this.baseDocTypeDescriptor.merge((DocumentTypeDescriptor)contribution);
            }
        }
    }

    public void applicationStarted(ComponentContext context) throws Exception {
        this.addToutaticeDocType(this.baseDocTypeDescriptor);
    }

    public void setExcludedRules(RulesDescriptor rules) {
        Object[] facets;
        Object[] types = rules.getTypes();
        if (ArrayUtils.isNotEmpty((Object[])types)) {
            this.excludedRules.put(TYPES_RULE, Arrays.asList(types));
        }
        if (ArrayUtils.isNotEmpty((Object[])(facets = rules.getFacets()))) {
            this.excludedRules.put(FACETS_RULE, Arrays.asList(facets));
        }
    }

    private boolean verifyExcludedRule(DocumentType type) {
        boolean isExcluded;
        List<String> excludedTypes = this.excludedRules.get(TYPES_RULE);
        boolean hasExcludedTypes = false;
        if (excludedTypes != null) {
            String typeName = type.getName();
            hasExcludedTypes = excludedTypes.contains(typeName);
        }
        List<String> excludedFacets = this.excludedRules.get(FACETS_RULE);
        boolean hasExcludedFacet = false;
        if (excludedFacets != null) {
            Set facets = type.getFacets();
            Iterator<String> iterator = excludedFacets.iterator();
            while (iterator.hasNext() && !hasExcludedFacet) {
                hasExcludedFacet = facets.contains(iterator.next());
            }
        }
        boolean bl = isExcluded = hasExcludedTypes || hasExcludedFacet;
        if (isExcluded) {
            this.allExcludedTypes.add(type.getName());
        }
        return isExcluded;
    }

    @Override
    public void addToutaticeDocType(DocumentTypeDescriptor baseDocTypeDescriptor) throws Exception {
        DocumentType[] types = this.schemaManager.getDocumentTypes();
        SchemaManagerImpl schemaManagerImpl = (SchemaManagerImpl)this.schemaManager;
        ArrayList<DocumentTypeDescriptor> excludedDocTypesDesc = new ArrayList<DocumentTypeDescriptor>();
        HashMap<String, DocumentTypeImpl> excludedDocTypes = new HashMap<String, DocumentTypeImpl>();
        HashMap<String, Set<String>> excludedDocTypesExtending = new HashMap<String, Set<String>>();
        for (DocumentType type : types) {
            String name = type.getName();
            if ("Document".equals(name)) continue;
            if (!this.verifyExcludedRule(type)) {
                DocumentTypeDescriptor baseDocTypeDesc = baseDocTypeDescriptor.clone();
                baseDocTypeDesc.name = name;
                schemaManagerImpl.registerDocumentType(baseDocTypeDesc);
                continue;
            }
            DocumentTypeDescriptor exDocTypeDesc = schemaManagerImpl.getDocumentTypeDescriptor(name);
            excludedDocTypesDesc.add(exDocTypeDesc);
            excludedDocTypes.put(name, (DocumentTypeImpl)type);
            excludedDocTypesExtending.put(name, schemaManagerImpl.getDocumentTypeNamesExtending(name));
        }
        this.restoreDataModel(schemaManagerImpl, excludedDocTypesDesc, excludedDocTypes, excludedDocTypesExtending);
        schemaManagerImpl.dirty = false;
        log.warn((Object)("Excluded Types from toutatice's schema setting: " + this.allExcludedTypes.toString()));
    }

    private void restoreDataModel(SchemaManagerImpl schemaManagerImpl, List<DocumentTypeDescriptor> excludedDocTypesDesc, Map<String, DocumentTypeImpl> excludedDocTypes, Map<String, Set<String>> excludedDocTypesExtending) {
        schemaManagerImpl.allDocumentTypes.removeAll(excludedDocTypesDesc);
        schemaManagerImpl.recompute();
        schemaManagerImpl.allDocumentTypes.addAll(excludedDocTypesDesc);
        schemaManagerImpl.documentTypesExtending.putAll(excludedDocTypesExtending);
        this.restoreFacetsByTypes(schemaManagerImpl, excludedDocTypes);
        schemaManagerImpl.documentTypes.putAll(excludedDocTypes);
    }

    private void restoreFacetsByTypes(SchemaManagerImpl schemaManagerImpl, Map<String, DocumentTypeImpl> excludedDocTypes) {
        for (DocumentType documentType : excludedDocTypes.values()) {
            for (String facet : documentType.getFacets()) {
                HashSet<String> set = (HashSet<String>)schemaManagerImpl.documentTypesForFacet.get(facet);
                if (set == null) {
                    set = new HashSet<String>();
                    schemaManagerImpl.documentTypesForFacet.put(facet, set);
                }
                set.add(documentType.getName());
            }
        }
    }
}

