/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.drive.services;

import fr.toutatice.ecm.drive.services.DocumentDriveInfosProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.runtime.api.Framework;

public class DocumentDriveInfosProviderImpl
implements DocumentDriveInfosProvider {
    private static final Log log = LogFactory.getLog(DocumentDriveInfosProviderImpl.class);
    public static final String OTTC_PORTAL_DRIVE_SYNC_ENABLED = "ottc.portal.drive.sync.enabled";
    protected static final String IS_UNDER_SYNCHRONIZATION_ROOT = "nuxeoDriveIsUnderSynchronizationRoot";
    protected static final String CURRENT_SYNCHRONIZATION_ROOT = "nuxeoDriveCurrentSynchronizationRoot";

    public Map<String, Object> fetchInfos(CoreSession coreSession, DocumentModel currentDocument) throws ClientException {
        long begin = System.currentTimeMillis();
        TreeMap<String, Object> synchronizationInfos = new TreeMap<String, Object>();
        if (Framework.isBooleanPropertyTrue((String)OTTC_PORTAL_DRIVE_SYNC_ENABLED)) {
            if (this.canSynchronizeCurrentDocument(coreSession, currentDocument)) {
                synchronizationInfos.put("canSynchronize", "true");
            } else if (this.canUnSynchronizeCurrentDocument(coreSession, currentDocument)) {
                synchronizationInfos.put("canUnsynchronize", "true");
            } else if (this.canNavigateToCurrentSynchronizationRoot(coreSession, currentDocument)) {
                synchronizationInfos.put("canNavigateToCurrentSynchronizationRoot", "true");
                synchronizationInfos.put("synchronizationRootPath", this.getCurrentSynchronizationRoot(coreSession, currentDocument).getPathAsString());
            }
        }
        if (log.isTraceEnabled()) {
            long end = System.currentTimeMillis();
            log.trace((Object)(": " + String.valueOf(end - begin) + " ms"));
        }
        return synchronizationInfos;
    }

    protected DocumentModelList getCurrentPath(CoreSession coreSession, DocumentModel currentDocument) throws ClientException {
        DocumentModelListImpl parentDocsList = new DocumentModelListImpl();
        List fromRoot = coreSession.getParentDocuments(currentDocument.getRef());
        parentDocsList.addAll((Collection)fromRoot);
        Collections.reverse(parentDocsList);
        return parentDocsList;
    }

    public DocumentModel getCurrentSynchronizationRoot(CoreSession coreSession, DocumentModel currentDocument) throws ClientException {
        NuxeoDriveManager driveManager = (NuxeoDriveManager)Framework.getLocalService(NuxeoDriveManager.class);
        Set references = driveManager.getSynchronizationRootReferences(coreSession);
        DocumentModelList path = this.getCurrentPath(coreSession, currentDocument);
        DocumentModel root = null;
        for (DocumentModel parent : path) {
            if (!references.contains(parent.getRef())) continue;
            root = parent;
            break;
        }
        return root;
    }

    public boolean canSynchronizeCurrentDocument(CoreSession coreSession, DocumentModel currentDocument) throws ClientException {
        if (currentDocument == null) {
            return false;
        }
        return this.isSyncRootCandidate(coreSession, currentDocument) && this.getCurrentSynchronizationRoot(coreSession, currentDocument) == null;
    }

    public boolean canUnSynchronizeCurrentDocument(CoreSession coreSession, DocumentModel currentDocument) throws ClientException {
        if (currentDocument == null) {
            return false;
        }
        if (!this.isSyncRootCandidate(coreSession, currentDocument)) {
            return false;
        }
        DocumentRef currentDocRef = currentDocument.getRef();
        DocumentModel currentSyncRoot = this.getCurrentSynchronizationRoot(coreSession, currentDocument);
        if (currentSyncRoot == null) {
            return false;
        }
        return currentDocRef.equals(currentSyncRoot.getRef());
    }

    public boolean canNavigateToCurrentSynchronizationRoot(CoreSession coreSession, DocumentModel currentDocument) throws ClientException {
        if (currentDocument == null) {
            return false;
        }
        if ("deleted".equals(currentDocument.getCurrentLifeCycleState())) {
            return false;
        }
        DocumentRef currentDocRef = currentDocument.getRef();
        DocumentModel currentSyncRoot = this.getCurrentSynchronizationRoot(coreSession, currentDocument);
        if (currentSyncRoot == null) {
            return false;
        }
        return !currentDocRef.equals(currentSyncRoot.getRef());
    }

    protected boolean isSyncRootCandidate(CoreSession coreSession, DocumentModel doc) throws ClientException {
        if (!doc.isFolder()) {
            return false;
        }
        if ("deleted".equals(doc.getCurrentLifeCycleState())) {
            return false;
        }
        return coreSession.hasPermission(doc.getRef(), "AddChildren");
    }
}

