/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.elasticsearch.helper;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class SQLHelper {
    private Pattern predicatesPattern = Pattern.compile(".+WHERE\\s(.+)");
    private Pattern expressionPattern = Pattern.compile("^[^']+'(.+)'[^']*$");
    private Pattern escapePattern = Pattern.compile("(\\w(?:\\w*\\s*'+\\s*\\w+)+\\w)");
    private static SQLHelper INSTANCE = new SQLHelper();

    private SQLHelper() {
    }

    public static SQLHelper getInstance() {
        return INSTANCE;
    }

    public String escape(String query) {
        String escapedQuery = query;
        Matcher m = this.predicatesPattern.matcher(query);
        if (m.matches()) {
            String[] predicates;
            for (String predicate : predicates = m.group(1).split("\\w+:\\w+")) {
                Matcher mexp;
                if (!StringUtils.isNotBlank((String)predicate) || StringUtils.containsIgnoreCase((String)predicate, (String)"BETWEEN") || !(mexp = this.expressionPattern.matcher(predicate)).matches()) continue;
                String expression = mexp.group(1);
                Matcher escpm = this.escapePattern.matcher(expression);
                while (escpm.find()) {
                    String item = escpm.group(1);
                    escapedQuery = escapedQuery.replace(item, item.replace("'", "\\'"));
                }
            }
        }
        return escapedQuery;
    }
}

