/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.webeditor;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeFileHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeImageCollectionHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Part;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.ecm.platform.ui.web.util.files.FileUtils;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;
import org.nuxeo.ecm.webapp.note.EditorImageActionsBean;

@Name(value="editorImageActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=31)
public class ToutaticeEditorImageActionsBean
extends EditorImageActionsBean {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ToutaticeEditorImageActionsBean.class);
    @In(required=false, create=true)
    protected transient DocumentsListsManager documentsListsManager;
    private static final String SEARCH_QUERY = "SELECT * FROM Document WHERE %s";
    private static final String THUMBNAIL_SRC_PATH = "%snxthumb/default/%s/blobholder:0/%s";
    @In(create=true, required=false)
    private transient CoreSession documentManager;
    private List<DocumentModel> resultDocuments;
    private boolean hasSearchResults = false;
    private static final int SEARCH_IN_MEDIA = 0;
    private static final int SEARCH_IN_SPACE = 1;
    private int searchInSpace = 0;
    private String selectedSize = "Medium";
    private String imageUrlAttr;
    private boolean isImageUploadedAttr = false;
    private boolean isImage = true;
    @RequestParameter
    private String selectedTab;
    private String oldSelectedTab;
    @RequestParameter
    private String libraryRoot;
    @RequestParameter
    private String currentLibraryNodeId;
    @RequestParameter
    private String previousLibraryNodeId;
    private DocumentModel currentLibraryNode;
    private DocumentModel previousLibraryNode;

    public boolean getLibraryRoot() {
        boolean root = true;
        if (StringUtils.isNotBlank((String)this.libraryRoot)) {
            root = Boolean.valueOf(this.libraryRoot);
        }
        return root;
    }

    public void setLibraryRoot(boolean root) {
        this.libraryRoot = String.valueOf(root);
    }

    public String getCurrentLibraryNodeId() {
        return this.currentLibraryNodeId;
    }

    public void setCurrentLibraryNodeId(String currentLibraryNodeId) {
        this.currentLibraryNodeId = currentLibraryNodeId;
    }

    public String getPreviousLibraryNodeId() {
        return this.previousLibraryNodeId;
    }

    public void setPreviousLibraryNodeId(String previousLibraryNodeId) {
        this.previousLibraryNodeId = previousLibraryNodeId;
    }

    public DocumentModel getCurrentLibraryNode() {
        if (this.getLibraryRoot()) {
            this.currentLibraryNode = ToutaticeDocumentHelper.getMediaSpace((DocumentModel)this.navigationContext.getCurrentDocument(), (CoreSession)this.documentManager);
        } else if (StringUtils.isNotBlank((String)this.currentLibraryNodeId)) {
            IdRef idRef = new IdRef(this.currentLibraryNodeId);
            this.currentLibraryNode = this.documentManager.getDocument((DocumentRef)idRef);
        }
        return this.currentLibraryNode;
    }

    public DocumentModel getPreviousLibraryNode() {
        if (this.previousLibraryNodeId != null) {
            IdRef idRef = new IdRef(this.previousLibraryNodeId);
            this.previousLibraryNode = this.documentManager.getDocument((DocumentRef)idRef);
        }
        return this.previousLibraryNode;
    }

    public String getImageUrlAttr() {
        return this.imageUrlAttr;
    }

    public void setImageUrlAttr(String imageUrlAttr) {
        this.imageUrlAttr = imageUrlAttr;
    }

    public boolean isImageUploadedAttr() {
        return this.isImageUploadedAttr;
    }

    public void setImageUploadedAttr(boolean isImageUploadedAttr) {
        this.isImageUploadedAttr = isImageUploadedAttr;
    }

    public String getUrlForImage() {
        super.getUrlForImage();
        this.isImageUploadedAttr = false;
        return this.imageUrlAttr;
    }

    public boolean getIsImageUploaded() {
        return this.isImageUploadedAttr;
    }

    public String getMediaSpaceName() throws ClientException {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        if (ToutaticeDocumentHelper.getMediaSpace((DocumentModel)doc, (CoreSession)this.documentManager) != null) {
            return ToutaticeDocumentHelper.getMediaSpace((DocumentModel)doc, (CoreSession)this.documentManager).getTitle();
        }
        return null;
    }

    public String getSpaceName() throws ClientException {
        DocumentModel space = this.navigationContext.getCurrentSuperSpace();
        if (null != space) {
            return space.getTitle();
        }
        this.searchInSpace = 2;
        return null;
    }

    public int getSearchInSpace() throws ClientException {
        if (this.searchInSpace == 0 && ToutaticeDocumentHelper.getMediaSpace((DocumentModel)this.navigationContext.getCurrentDocument(), (CoreSession)this.documentManager) == null) {
            this.searchInSpace = 1;
        }
        return this.searchInSpace;
    }

    public void setSearchInSpace(int searchInSpace) {
        this.searchInSpace = searchInSpace;
    }

    public boolean getInToutaticeCreationMode() {
        DocumentModel doc = this.navigationContext.getChangeableDocument();
        if (doc == null) {
            doc = this.navigationContext.getCurrentDocument();
        }
        if (doc == null) {
            return false;
        }
        if (doc.getId() == null) {
            return true;
        }
        return !doc.hasSchema("toutatice");
    }

    public String searchImages(String view) throws ClientException {
        this.searchImages();
        return view;
    }

    public String searchImages() throws ClientException {
        String searchKeywords = this.getSearchKeywords();
        log.debug((Object)("Entering searchDocuments with keywords: " + searchKeywords));
        this.resultDocuments = null;
        ArrayList<String> constraints = new ArrayList<String>();
        if (searchKeywords != null && (searchKeywords = searchKeywords.trim()).length() > 0 && !searchKeywords.equals("*")) {
            constraints.add(String.format("ecm:fulltext LIKE '%s'", searchKeywords));
        }
        if (this.searchInSpace == 0 && ToutaticeDocumentHelper.getMediaSpace((DocumentModel)this.navigationContext.getCurrentDocument(), (CoreSession)this.documentManager) != null) {
            constraints.add("ecm:path STARTSWITH '" + ToutaticeDocumentHelper.getMediaSpace((DocumentModel)this.navigationContext.getCurrentDocument(), (CoreSession)this.documentManager).getPathAsString().replace("'", "\\'") + "'");
        } else if (this.searchInSpace == 1) {
            constraints.add("ecm:path STARTSWITH '" + this.navigationContext.getCurrentSuperSpace().getPathAsString().replace("'", "\\'") + "'");
        }
        constraints.add("ecm:primaryType = 'Picture'");
        constraints.add("ecm:isCheckedInVersion = 0 AND ecm:isProxy = 0 AND ecm:currentLifeCycleState!='deleted'");
        String query = String.format(SEARCH_QUERY, StringUtils.join(constraints, (String)" AND "));
        this.resultDocuments = this.documentManager.query(query, 100);
        this.hasSearchResults = !this.resultDocuments.isEmpty();
        log.debug((Object)("query result contains: " + this.resultDocuments.size() + " docs."));
        return "editor_image_upload";
    }

    public boolean getHasSearchResults() {
        return this.hasSearchResults;
    }

    public List<DocumentModel> getSearchImageResults() {
        return this.resultDocuments;
    }

    public String getSelectedSize() {
        return this.selectedSize;
    }

    public void setSelectedSize(String selectedSize) {
        this.selectedSize = selectedSize;
    }

    public String getImageProperty() {
        return this.selectedSize + ":content";
    }

    public String getSelectedTab() {
        if (this.selectedTab != null) {
            this.oldSelectedTab = this.selectedTab;
        } else if (this.oldSelectedTab == null) {
            this.oldSelectedTab = "ATTACH_IMGS";
        }
        return this.oldSelectedTab;
    }

    public boolean getIsImage() {
        return this.isImage;
    }

    public String uploadImage() throws ClientException {
        Part uploadedImg = this.getUploadedImage();
        String uploadedImgName = FileUtils.retrieveFilename((Part)uploadedImg);
        if (null == uploadedImg || StringUtils.isBlank((String)uploadedImgName)) {
            return null;
        }
        try {
            DocumentModel doc = this.navigationContext.getCurrentDocument();
            Blob uploadedImageBlob = FileUtils.createSerializableBlob((InputStream)uploadedImg.getInputStream(), (String)uploadedImgName, (String)uploadedImg.getContentType());
            boolean isImage = ToutaticeFileHelper.instance().isImageTypeFile(uploadedImgName, uploadedImageBlob);
            if (isImage) {
                List files = (List)((Object)doc.getPropertyValue("ttc:images"));
                HashMap<String, String> item = new HashMap<String, String>();
                item.put("filename", uploadedImgName);
                item.put("file", (String)uploadedImageBlob);
                ToutaticeImageCollectionHelper.instance().add(files, item);
                doc.setPropertyValue("ttc:images", (Serializable)((Object)files));
                this.documentManager.saveDocument(doc);
                this.documentManager.save();
                this.imageUrlAttr = DocumentModelFunctions.complexFileUrl((String)"downloadFile", (DocumentModel)doc, (String)"ttc:images", (int)files.indexOf(item), (String)"file", (String)uploadedImgName);
                this.isImageUploadedAttr = true;
            } else {
                this.isImage = false;
                log.debug((Object)"The binary file to upload hasn't the correct mimetype.");
            }
            return "editor_image_upload";
        }
        catch (IOException e) {
            log.error((Object)("Failed to upload the image, error: " + e.getMessage()));
            throw new ClientException((Throwable)e);
        }
    }

    public String addImageFromNuxeo() throws ClientException {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        List selectedDocumentList = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        if (null != selectedDocumentList && 0 < selectedDocumentList.size()) {
            List files = (List)((Object)currentDoc.getPropertyValue("ttc:images"));
            block0: for (DocumentModel selectedDocument : selectedDocumentList) {
                Map picture = selectedDocument.getProperties("picture");
                List views = (List)picture.get("views");
                for (Map view : views) {
                    if (!"original".equalsIgnoreCase((String)view.get("tag"))) continue;
                    Blob blob = (Blob)view.get("content");
                    HashMap<String, Object> fileMap = new HashMap<String, Object>(2);
                    fileMap.put("file", blob);
                    fileMap.put("filename", selectedDocument.getTitle());
                    if (files.contains(fileMap)) continue block0;
                    ToutaticeImageCollectionHelper.instance().add(files, fileMap);
                    continue block0;
                }
            }
            this.documentsListsManager.resetWorkingList("CURRENT_SELECTION");
            currentDoc.setPropertyValue("ttc:images", (Serializable)((Object)files));
            this.documentManager.saveDocument(currentDoc);
            this.documentManager.save();
        }
        return "";
    }

    public String searchVideos(String view) throws ClientException {
        super.searchVideos();
        return view;
    }

    public String getThumbnailSrc(DocumentModel pictureOrFolder) {
        String src = "";
        if (pictureOrFolder != null) {
            String baseUrl = BaseURL.getBaseURL();
            src = pictureOrFolder.isFolder() ? baseUrl + "icons/workspace.gif" : String.format(THUMBNAIL_SRC_PATH, baseUrl, pictureOrFolder.getId(), pictureOrFolder.getTitle());
        }
        return src;
    }

    public List<DocumentModel> getLibraryPicturesNFolders(DocumentModel node) {
        DocumentModelList children;
        ArrayList<DocumentModel> picturesNFolders = new ArrayList<DocumentModel>(0);
        Filter filter = new Filter(){
            private static final long serialVersionUID = 2878502523162688751L;

            public boolean accept(DocumentModel docModel) {
                boolean isNotProxy = !docModel.isProxy();
                boolean isPicture = "Picture".equals(docModel.getType());
                boolean isFolder = docModel.isFolder();
                return isNotProxy && (isPicture || isFolder);
            }
        };
        if (node != null && (children = this.documentManager.getChildren(node.getRef(), null, filter, null)) != null && !children.isEmpty()) {
            picturesNFolders.addAll((Collection<DocumentModel>)children);
        }
        return picturesNFolders;
    }

    public String goTo(String viewId) {
        return viewId;
    }
}

