/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.model.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.ecm.webengine.model.LinkDescriptor;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.runtime.contribution.impl.AbstractContributionRegistry;

public class LinkRegistry
extends AbstractContributionRegistry<String, LinkDescriptor> {
    protected final Map<String, LinkDescriptor[]> links = new ConcurrentHashMap<String, LinkDescriptor[]>();

    public List<LinkDescriptor> getLinks(String category) {
        LinkDescriptor[] descriptors = this.links.get(category);
        if (descriptors != null && descriptors.length > 0) {
            return Arrays.asList(descriptors);
        }
        return new ArrayList<LinkDescriptor>();
    }

    public List<LinkDescriptor> getActiveLinks(Resource context, String category) {
        ArrayList<LinkDescriptor> result = new ArrayList<LinkDescriptor>();
        LinkDescriptor[] descriptors = this.links.get(category);
        if (descriptors != null && descriptors.length > 0) {
            for (LinkDescriptor descriptor : descriptors) {
                if (!descriptor.isEnabled(context)) continue;
                result.add(descriptor);
            }
        }
        return result;
    }

    public synchronized void registerLink(LinkDescriptor td) {
        this.addFragment(td.getId(), td, new String[0]);
    }

    public void unregisterLink(LinkDescriptor td) {
        this.removeFragment(td.getId(), td);
    }

    @Override
    protected LinkDescriptor clone(LinkDescriptor object) {
        try {
            return object.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Must never happens");
        }
    }

    @Override
    protected void applyFragment(LinkDescriptor object, LinkDescriptor fragment) {
        object.applyFragment(fragment);
    }

    @Override
    protected void applySuperFragment(LinkDescriptor object, LinkDescriptor superFragment) {
    }

    @Override
    protected void installContribution(String key, LinkDescriptor object) {
        List<String> cats = object.getCategories();
        for (String cat : cats) {
            this.installLink(cat, object);
        }
    }

    @Override
    protected void updateContribution(String key, LinkDescriptor object, LinkDescriptor oldValue) {
        this.removeLink(oldValue);
        this.installContribution(key, object);
    }

    @Override
    protected void uninstallContribution(String key, LinkDescriptor object) {
        this.removeLink(object);
    }

    @Override
    protected boolean isMainFragment(LinkDescriptor object) {
        return !object.isFragment();
    }

    protected void installLink(String category, LinkDescriptor link) {
        LinkDescriptor[] descriptors = this.links.get(category);
        if (descriptors == null) {
            descriptors = new LinkDescriptor[]{link};
        } else {
            LinkDescriptor[] ar = new LinkDescriptor[descriptors.length + 1];
            System.arraycopy(descriptors, 0, ar, 0, descriptors.length);
            ar[descriptors.length] = link;
            descriptors = ar;
        }
        this.links.put(category, descriptors);
    }

    protected void removeLink(LinkDescriptor link) {
        List<String> cats = link.getCategories();
        for (String cat : cats) {
            this.removeLink(cat, link);
        }
    }

    protected void removeLink(String category, LinkDescriptor link) {
        LinkDescriptor[] descriptors = this.links.get(category);
        if (descriptors == null) {
            return;
        }
        for (int i = 0; i < descriptors.length; ++i) {
            if (!link.getId().equals(descriptors[i])) continue;
            if (descriptors.length == 1 && i == 0) {
                this.links.remove(category);
                return;
            }
            LinkDescriptor[] tmp = new LinkDescriptor[descriptors.length - 1];
            if (i > 0) {
                System.arraycopy(descriptors, 0, tmp, 0, i);
            }
            if (i < descriptors.length - 1) {
                System.arraycopy(descriptors, i + 1, tmp, i, descriptors.length - i - 1);
            }
            this.links.put(category, tmp);
            return;
        }
    }
}

