/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.file;

import com.phloc.commons.io.file.EFileIOOperation;
import com.phloc.commons.io.file.FileIOError;
import com.phloc.commons.io.file.FileOperations;
import com.phloc.commons.io.file.IFileOperationCallback;
import com.phloc.commons.io.file.IFileOperationManager;
import com.phloc.commons.string.ToStringGenerator;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class FileOperationManager
implements IFileOperationManager {
    private FileIOError m_aLastError;
    private final IFileOperationCallback m_aCallback;

    public FileOperationManager() {
        this(null);
    }

    public FileOperationManager(@Nullable IFileOperationCallback iFileOperationCallback) {
        this.m_aCallback = iFileOperationCallback;
    }

    @Override
    @Nullable
    public FileIOError getLastError() {
        return this.m_aLastError;
    }

    @Override
    @Nullable
    public EFileIOOperation getLastOperation() {
        return this.m_aLastError == null ? null : this.m_aLastError.getOperation();
    }

    private void _handleLastError(@Nonnull FileIOError fileIOError) {
        if (this.m_aCallback != null) {
            if (fileIOError.isSuccess()) {
                this.m_aCallback.onSuccess(fileIOError.getOperation(), fileIOError.getFile1(), fileIOError.getFile2());
            } else {
                this.m_aCallback.onError(fileIOError.getOperation(), fileIOError.getErrorCode(), fileIOError.getFile1(), fileIOError.getFile2(), fileIOError.getException());
            }
        }
    }

    @Override
    @Nonnull
    public FileIOError createDir(@Nonnull File file) {
        this.m_aLastError = FileOperations.createDir(file);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError createDirIfNotExisting(@Nonnull File file) {
        this.m_aLastError = FileOperations.createDirIfNotExisting(file);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError createDirRecursive(@Nonnull File file) {
        this.m_aLastError = FileOperations.createDirRecursive(file);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError createDirRecursiveIfNotExisting(@Nonnull File file) {
        this.m_aLastError = FileOperations.createDirRecursiveIfNotExisting(file);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError deleteDir(@Nonnull File file) {
        this.m_aLastError = FileOperations.deleteDir(file);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError deleteDirIfExisting(@Nonnull File file) {
        this.m_aLastError = FileOperations.deleteDirIfExisting(file);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError deleteDirRecursive(@Nonnull File file) {
        this.m_aLastError = FileOperations.deleteDirRecursive(file);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError deleteDirRecursiveIfExisting(@Nonnull File file) {
        this.m_aLastError = FileOperations.deleteDirRecursiveIfExisting(file);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError deleteFile(@Nonnull File file) {
        this.m_aLastError = FileOperations.deleteFile(file);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError deleteFileIfExisting(@Nonnull File file) {
        this.m_aLastError = FileOperations.deleteFileIfExisting(file);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError renameDir(@Nonnull File file, @Nonnull File file2) {
        this.m_aLastError = FileOperations.renameDir(file, file2);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError renameFile(@Nonnull File file, @Nonnull File file2) {
        this.m_aLastError = FileOperations.renameFile(file, file2);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError copyDirRecursive(@Nonnull File file, @Nonnull File file2) {
        this.m_aLastError = FileOperations.copyDirRecursive(file, file2);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError copyFile(@Nonnull File file, @Nonnull File file2) {
        this.m_aLastError = FileOperations.copyFile(file, file2);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    public String toString() {
        return new ToStringGenerator(this).append("lastError", this.m_aLastError).append("callback", this.m_aCallback).toString();
    }
}

