/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.collab.tools.workspaces;

import fr.toutatice.ecm.platform.collab.tools.notifications.DocumentNotificationInfosProvider;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Services.WorkspaceUnsubscribe", category="Services", label="Remove all notifications within a workspace", description="Remove all notifications within a workspace")
public class WorkspaceUnsubscribe {
    public static final String ID = "Services.WorkspaceUnsubscribe";
    @Context
    protected CoreSession session;
    @Param(name="workspaceId")
    private String workspaceId;
    @Param(name="userId")
    private String userId;

    @OperationMethod
    public void run() throws ClientException, ClassNotFoundException {
        DocumentModelList workspaces = this.session.query("SELECT * FROM Workspace where webc:url = '" + this.workspaceId + "'");
        if (workspaces.size() == 1) {
            DocumentModel workspace = (DocumentModel)workspaces.get(0);
            DocumentNotificationInfosProvider service = (DocumentNotificationInfosProvider)Framework.getService(DocumentNotificationInfosProvider.class);
            service.workspaceUnsubscribe(this.session, workspace, this.userId);
            ElasticSearchService es = (ElasticSearchService)Framework.getService(ElasticSearchService.class);
            NxQueryBuilder query = new NxQueryBuilder(this.session);
            query.nxql("SELECT * FROM Document WHERE ecm:path STARTSWITH '" + workspace.getPathAsString() + "' AND ecm:acl/* = '" + this.userId + "'");
            DocumentModelList query2 = es.query(query);
            for (DocumentModel docWithAcls : query2) {
                ACL[] acls;
                boolean AcpModified = false;
                ACP acp = this.session.getACP(docWithAcls.getRef());
                for (ACL acl : acls = acp.getACLs()) {
                    for (ACE ace : acl.getACEs()) {
                        if (!ace.getUsername().equals(this.userId)) continue;
                        acl.remove((Object)ace);
                        AcpModified = true;
                    }
                }
                if (!AcpModified) continue;
                this.session.setACP(docWithAcls.getRef(), acp, true);
            }
        }
    }
}

