/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.internal;

import com.sun.jdmk.internal.ClassLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class BackupFileHandler {
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "BackupFileHandler");

    public static File createBackupFile(File file, String extension) {
        if (extension == null) {
            extension = ".bak";
        }
        String name = file.getName();
        File parentFile = file.getParentFile() == null ? new File("." + File.separator) : file.getParentFile();
        File backupFile = new File(parentFile, String.valueOf(name) + extension);
        if (logger.finestOn()) {
            logger.finest("createBackupFile", "backup file : " + backupFile + ".");
        }
        try {
            backupFile.delete();
        }
        catch (Exception e) {
            if (logger.finestOn()) {
                logger.finest("createBackupFile", e);
            }
            if (logger.finestOn()) {
                logger.finest("createBackupFile", "Unable to delete the previous backup file");
            }
            return null;
        }
        if (logger.finestOn()) {
            logger.finest("createBackupFile", "Previous backup file : " + backupFile + " deleted.");
        }
        try {
            BackupFileHandler.copyFile(file, backupFile);
        }
        catch (Exception e) {
            if (logger.finestOn()) {
                logger.finest("createBackupFile", e);
            }
            if (logger.finestOn()) {
                logger.finest("createBackupFile", "Unable to copy the file in a bak file.");
            }
            return null;
        }
        return backupFile;
    }

    public static void deleteBackupFile(File backupFile) {
        try {
            backupFile.delete();
        }
        catch (Exception e) {
            if (logger.finestOn()) {
                logger.finest("deleteBackupFile", e);
            }
            return;
        }
        if (logger.finestOn()) {
            logger.finest("deleteBackupFile", "backup file " + backupFile + " deleted.");
        }
    }

    private static void copyFile(File in, File out) throws Exception {
        FileInputStream fis = new FileInputStream(in);
        FileOutputStream fos = new FileOutputStream(out);
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            fos.write(buf, 0, i);
        }
        fis.close();
        fos.close();
    }
}

