/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.es.customizer.writers.impl;

import fr.toutatice.ecm.es.customizer.writers.api.AbstractCustomJsonESWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.ldap.LDAPDirectory;
import org.nuxeo.runtime.api.Framework;

public class UserProfileWriter
extends AbstractCustomJsonESWriter {
    @Override
    public boolean accept(DocumentModel doc) {
        return doc.getType().equals("UserProfile");
    }

    @Override
    public void writeData(JsonGenerator jg, DocumentModel doc, String[] schemas, Map<String, String> contextParameters) throws IOException {
        DirectoryService service;
        LDAPDirectory directory;
        DocumentModel entry;
        String login = null;
        for (ACL acl : doc.getACP().getACLs()) {
            for (ACE ace : acl.getACEs()) {
                if (!ace.getPermission().equals("Everything") || !ace.isGranted()) continue;
                login = ace.getUsername();
            }
        }
        if (login != null && (entry = (directory = (LDAPDirectory)(service = (DirectoryService)Framework.getService(DirectoryService.class)).getDirectory("userLdapDirectory")).getSession().getEntry(login)) != null) {
            Serializable firstName = entry.getPropertyValue("firstName");
            Serializable lastName = entry.getPropertyValue("lastName");
            String displayName = null;
            if (firstName != null && lastName != null) {
                displayName = firstName.toString() + " " + lastName.toString();
            } else if (lastName != null) {
                displayName = lastName.toString();
            }
            HashSet<String> workspaces = new HashSet<String>();
            List groups = (List)((Object)entry.getPropertyValue("groups"));
            for (String group : groups) {
                String[] split = group.split("_");
                workspaces.add(split[0]);
            }
            jg.writeStringField("dc:title", displayName);
            jg.writeStringField("ttc_userprofile:login", login);
            jg.writeArrayFieldStart("ttc_userprofile:workspaces");
            for (String workspace : workspaces) {
                jg.writeString(workspace);
            }
            jg.writeEndArray();
        }
    }
}

