/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.ecm.feature.news.scanner;

import fr.toutatice.ecm.platform.core.helper.ToutaticeQueryHelper;
import java.util.Date;
import java.util.Map;
import javax.security.auth.login.LoginContext;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.runtime.api.Framework;
import org.opentoutatice.ecm.feature.news.consistency.DateRepairer;
import org.opentoutatice.ecm.feature.news.model.SpaceMember;
import org.opentoutatice.ecm.feature.news.scanner.DateUpdaterTools;
import org.opentoutatice.ecm.feature.news.scanner.io.NewsPeriod;
import org.opentoutatice.ecm.scanner.AbstractScanUpdater;
import org.richfaces.component.NumberUtils;

public class NewsUpdater
extends AbstractScanUpdater {
    private static final Log log = LogFactory.getLog(NewsUpdater.class);
    private static final String UWS_ROOT_QUERY = "select * from UserWorkspacesRoot where ecm:isProxy = 0 and ecm:isVersion = 0 and ecm:currentLifeCycleState <> 'deleted'";
    private SpaceMember member;
    private Date currentDate;
    private static DocumentModel userWorkspacesRoot = null;

    public Date getCurrentDate() {
        return this.currentDate;
    }

    public SpaceMember getMember() {
        return this.member;
    }

    public void setMember(SpaceMember member) {
        this.member = member;
    }

    public void setCurrentDate(Date currentDate) {
        this.currentDate = currentDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DocumentModel getUserWorkspacesRoot() throws Exception {
        if (userWorkspacesRoot == null) {
            LoginContext login = null;
            CoreSession sessionSystem = null;
            try {
                login = Framework.login();
                sessionSystem = CoreInstance.openCoreSessionSystem(null);
                DocumentModelList uWorspacesRoots = ToutaticeQueryHelper.queryUnrestricted((CoreSession)sessionSystem, (String)UWS_ROOT_QUERY);
                userWorkspacesRoot = (DocumentModel)uWorspacesRoots.get(0);
            }
            finally {
                if (sessionSystem != null) {
                    sessionSystem.close();
                }
                if (login != null) {
                    login.logout();
                }
            }
        }
        return userWorkspacesRoot;
    }

    public static boolean isTestModeSet() {
        return Boolean.valueOf(Framework.getProperty((String)"ottc.news.mode.test"));
    }

    public Object toModel(Object scannedObject) throws Exception {
        return new SpaceMember((Map)scannedObject);
    }

    protected String getBoundaryValue(NewsPeriod newsPeriod) throws Exception {
        String boundaryValue = null;
        switch (newsPeriod) {
            case daily: {
                boundaryValue = (String)this.getParams().get("nextDailyBoundary");
                if (!log.isTraceEnabled()) break;
                log.trace((Object)("[Period]: " + boundaryValue));
                break;
            }
            case weekly: {
                boundaryValue = (String)this.getParams().get("nextWeeklyBoundary");
                if (!log.isTraceEnabled()) break;
                log.trace((Object)("[Period]: " + boundaryValue));
                break;
            }
            case error: {
                boundaryValue = (String)this.getParams().get("nextErrorBoundary");
                if (!log.isTraceEnabled()) break;
                log.trace((Object)("[Period]: " + boundaryValue));
                break;
            }
            case none: {
                boundaryValue = "0";
                break;
            }
        }
        return boundaryValue;
    }

    public boolean accept(int index, Object scannedObject) throws Exception {
        boolean periodAvaliable = this.testNewsPeriodAvaliable(scannedObject);
        boolean accepts = false;
        if (periodAvaliable) {
            this.currentDate = new Date();
            this.member = (SpaceMember)this.toModel(scannedObject);
            if (this.member.hasUserProfile()) {
                Date nextNewsDate = this.member.getNextNewsDate();
                boolean hasSubscribed = this.member.hasSubscribed();
                if (!hasSubscribed && nextNewsDate != null) {
                    this.member.setNextNewsDate(index, null);
                }
                if (hasSubscribed) {
                    boolean mustNotify;
                    boolean bl = mustNotify = nextNewsDate == null;
                    if (nextNewsDate != null) {
                        boolean bl2 = mustNotify = nextNewsDate.getTime() < this.currentDate.getTime();
                        if (NewsUpdater.isTestModeSet()) {
                            mustNotify = true;
                        }
                    }
                    accepts = mustNotify;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("[accepts]: " + accepts + ": " + "(hasSubscribed=" + hasSubscribed + " / mustNotify=" + mustNotify));
                    }
                }
                if (accepts && this.member != null && log.isInfoEnabled()) {
                    log.info((Object)("[Treating] " + this.member.getLogin() + " | " + this.member.getSpaceTitle()));
                }
            }
        } else if (log.isDebugEnabled()) {
            Map map = (Map)scannedObject;
            String login = (String)map.get("ttcs:spaceMembers/*1/login");
            String spaceTitle = (String)map.get("dc:title");
            log.debug((Object)("[Skipping] " + login + " | " + spaceTitle));
        }
        return accepts;
    }

    private boolean testNewsPeriodAvaliable(Object scannedObject) {
        Map map = (Map)scannedObject;
        String period = (String)map.get("ttcs:spaceMembers/*1/newsPeriod");
        return period != null && !NewsPeriod.none.equals((Object)NewsPeriod.valueOf(period));
    }

    public Object initialize(int index, Object scannedObject) throws Exception {
        Object period;
        Date nextNewsDate = this.member.getNextNewsDate();
        Date repairedNextNewsDate = null;
        Date formerNextNewsDate = nextNewsDate;
        if (nextNewsDate == null) {
            nextNewsDate = this.getNextNewsDate(this.currentDate, this.getBoundaryValue(this.member.getNewsPeriod()), true);
            this.member.setNextNewsDate(index, nextNewsDate);
            this.member.setLastNewsDate(index, this.currentDate);
        } else {
            period = this.member.getNewsPeriod();
            int boundary = NumberUtils.getNumber((Object)this.getBoundaryValue((NewsPeriod)((Object)period))).intValue();
            repairedNextNewsDate = DateRepairer.checkDateNRepair(period, nextNewsDate, boundary);
            if (nextNewsDate != null) {
                this.member.setNextNewsDate(index, repairedNextNewsDate);
            }
        }
        if (log.isDebugEnabled()) {
            period = this.member.getNewsPeriod().name();
            String repairedStatus = repairedNextNewsDate != null ? "(repaired)" : "(not repaired)";
            String inputDate = formerNextNewsDate != null ? DateFormatUtils.format((Date)formerNextNewsDate, (String)"dd-MM-yyyy HH:mm") : "Undefined";
            String outputDate = repairedNextNewsDate != null ? DateFormatUtils.format((Date)repairedNextNewsDate, (String)"dd-MM-yyyy HH:mm") : DateFormatUtils.format((Date)nextNewsDate, (String)"dd-MM-yyyy HH:mm");
            log.debug((Object)("INIT [" + (String)period + "] NextDate " + repairedStatus + " = " + inputDate + " -> " + outputDate));
        }
        return this.member;
    }

    public Object update(int index, Object scannedObject) throws Exception {
        Date formerNextNewsDate = this.member.getNextNewsDate();
        this.member.setLastNewsDate(index, this.currentDate);
        Date nextNewsDate = this.getNextNewsDate(this.currentDate, this.getBoundaryValue(this.member.getNewsPeriod()), false);
        this.member.setNextNewsDate(index, nextNewsDate);
        if (log.isDebugEnabled()) {
            String period = this.member.getNewsPeriod().name();
            String inputDate = formerNextNewsDate != null ? DateFormatUtils.format((Date)formerNextNewsDate, (String)"dd-MM-yyyy HH:mm") : "Undefined";
            String outputDate = DateFormatUtils.format((Date)nextNewsDate, (String)"dd-MM-yyyy HH:mm");
            log.debug((Object)("UPDATE [" + period + "] NextDate = " + inputDate + " -> " + outputDate));
        }
        return this.member;
    }

    public Date getNextNewsDate(Date previousBaseDate, String boundaryValue, boolean init) throws Exception {
        int interval = Integer.valueOf(boundaryValue);
        NewsPeriod newsPeriod = this.member.getNewsPeriod();
        return DateUpdaterTools.computeNextDate(newsPeriod, previousBaseDate, interval, init);
    }

    public Object updateOnError(int index, Object scannedObject) throws Exception {
        Date formernextNewsDate = this.member.getNextNewsDate();
        Date nextNewsDate = this.getNextNewsDate(this.currentDate, this.getBoundaryValue(NewsPeriod.error), false);
        this.member.setNextNewsDate(index, nextNewsDate);
        if (log.isDebugEnabled()) {
            String period = this.member.getNewsPeriod().name();
            log.debug((Object)("UPDATE [" + period + "] NextDate = " + DateFormatUtils.format((Date)formernextNewsDate, (String)"dd-MM-yyyy HH:mm") + " -> " + DateFormatUtils.format((Date)nextNewsDate, (String)"dd-MM-yyyy HH:mm")));
        }
        return this.member;
    }
}

