/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.ecm.attached.files.url.codec;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.seam.core.Manager;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.platform.ui.web.util.SeamComponentCallHelper;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.codec.DocumentFileCodec;

public class OttcAttachedFileCodec
extends DocumentFileCodec {
    public static final String CREATING_DOC_INDICATOR = "creatingDoc";
    public static final String URLPattern = "/(\\w+)/([a-zA-Z_0-9\\-]*|creatingDoc)(/([a-zA-Z_0-9/:\\-\\.\\]\\[]*))+(/([^\\?]*))+(\\?)?(.*)?";

    public OttcAttachedFileCodec() {
    }

    public OttcAttachedFileCodec(String prefix) {
        super(prefix);
    }

    public String getUrlFromDocumentView(DocumentView docView) {
        DocumentLocation docLoc = docView.getDocumentLocation();
        String filepath = docView.getParameter("FILE_PROPERTY_PATH");
        String filename = docView.getParameter("FILENAME");
        if (docLoc != null && filepath != null && filename != null) {
            ArrayList<String> items = new ArrayList<String>();
            items.add(this.getPrefix());
            if (org.apache.commons.lang.StringUtils.isBlank((String)docLoc.getServerName())) {
                items.add("default");
            } else {
                items.add(docLoc.getServerName());
            }
            if (docLoc.getDocRef() == null) {
                items.add(CREATING_DOC_INDICATOR);
            } else {
                items.add(docLoc.getDocRef().toString());
            }
            items.add(filepath);
            items.add(URIUtils.quoteURIPathToken((String)filename));
            String uri = StringUtils.join(items, (String)"/");
            HashMap<String, String> requestParams = new HashMap<String, String>(docView.getParameters());
            requestParams.remove("FILE_PROPERTY_PATH");
            requestParams.remove("FILENAME");
            if (docLoc.getDocRef() == null) {
                Manager conversationManager = (Manager)SeamComponentCallHelper.getSeamComponentByName((String)"org.jboss.seam.core.manager");
                requestParams.put(conversationManager.getConversationIdParameter(), conversationManager.getCurrentConversationId());
            }
            return URIUtils.addParametersToURIQuery((String)uri, requestParams);
        }
        return null;
    }

    public DocumentView getDocumentViewFromUrl(String url) {
        Pattern pattern = Pattern.compile(this.getPrefix() + URLPattern);
        Matcher m = pattern.matcher(url);
        if (m.matches() && m.groupCount() >= 4) {
            String query;
            Map requestParams;
            String server = m.group(1);
            String uuid = m.group(2);
            IdRef docRef = null;
            if (!CREATING_DOC_INDICATOR.equals(uuid)) {
                docRef = new IdRef(uuid);
            }
            HashMap<String, String> params = new HashMap<String, String>();
            if (m.groupCount() >= 4) {
                String filePropertyPath = m.group(4);
                params.put("FILE_PROPERTY_PATH", filePropertyPath);
            }
            if (m.groupCount() >= 6) {
                String filename = m.group(6);
                try {
                    filename = URLDecoder.decode(filename, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    filename = StringUtils.toAscii((String)filename);
                }
                int jsessionidIndex = filename.indexOf(";jsessionid");
                if (jsessionidIndex != -1) {
                    filename = filename.substring(0, jsessionidIndex);
                }
                params.put("FILENAME", filename);
            }
            if (m.groupCount() >= 8 && (requestParams = URIUtils.getRequestParameters((String)(query = m.group(8)))) != null) {
                params.putAll(requestParams);
            }
            DocumentLocationImpl docLoc = new DocumentLocationImpl(server, (DocumentRef)docRef);
            return new DocumentViewImpl((DocumentLocation)docLoc, null, params);
        }
        return null;
    }
}

