/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation.versioning;

import java.io.Serializable;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.VersioningOption;

@Operation(id="Document.CreateExplicitVersion", category="Document", label="Create a new major version tagging it as 'explicit'", description="Create a new major version tagging it as 'explicit' for the input document. Any modification made on the document by the chain will be automatically saved. Returns the version).")
public class CreateExplicitVersion {
    public static final String ID = "Document.CreateExplicitVersion";
    @Context
    protected CoreSession session;
    @Param(name="comment", required=false)
    protected String comment = "";

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) throws Exception {
        if (!doc.hasFacet("Versionable")) {
            throw new ClientException(String.format("The document (id:'%s') with title '%s' doesn't have 'versionable' facet", doc.getId(), doc.getTitle()));
        }
        doc.putContextData("VersioningOption", (Serializable)VersioningOption.MAJOR);
        doc.addFacet("ExplicitVersion");
        DocumentHelper.saveDocument((CoreSession)this.session, (DocumentModel)doc);
        doc.removeFacet("ExplicitVersion");
        return this.session.getLastDocumentVersion(doc.getRef());
    }
}

