/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeSilentProcessRunnerHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.versioning.VersioningService;

@Operation(id="Document.SetDomainID", category="Document", label="Set domainId.", description="Update domainID's value of document when created and its children when moved.")
public class SetDomainID {
    public static final String ID = "Document.SetDomainID";
    private static final Log log = LogFactory.getLog(SetDomainID.class);
    @Context
    protected CoreSession coreSession;
    private static final List<Class<?>> FILTERED_SERVICES_LIST = new ArrayList<Class<?>>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(EventService.class);
            this.add(VersioningService.class);
        }
    };

    @OperationMethod
    public DocumentModel run(DocumentModel doc) throws Exception {
        InnerSilentModeUpdateDomainID runner = new InnerSilentModeUpdateDomainID(this.coreSession, doc);
        runner.silentRun(true, FILTERED_SERVICES_LIST);
        return runner.getDocument();
    }

    private class InnerSilentModeUpdateDomainID
    extends ToutaticeSilentProcessRunnerHelper {
        private DocumentModel document;

        public InnerSilentModeUpdateDomainID(CoreSession session, DocumentModel document) {
            super(session);
            this.document = document;
        }

        public DocumentModel getDocument() throws ClientException {
            return this.document;
        }

        public void run() throws ClientException {
            try {
                this.updateDoc(this.document);
            }
            catch (Exception e) {
                throw new ClientException((Throwable)e);
            }
        }

        private void updateDoc(DocumentModel document) throws Exception {
            DocumentModel domain;
            if (!document.isImmutable() && document.hasSchema("toutatice") && null != (domain = this.getDomain(document))) {
                String domainID = (String)((Object)domain.getPropertyValue("ttc:domainID"));
                if (StringUtils.isBlank((String)domainID)) {
                    domainID = domain.getName();
                }
                document.setPropertyValue("ttc:domainID", (Serializable)((Object)domainID));
                this.session.saveDocument(document);
                if (document.isFolder()) {
                    StringBuilder query = new StringBuilder();
                    query.append("select * from Document where ecm:mixinType != 'HiddenInNavigation' AND ecm:isCheckedInVersion = 0 AND ");
                    query.append("ecm:currentLifeCycleState != 'deleted' AND ecm:isProxy = 0 AND ecm:parentId = '");
                    query.append(document.getId());
                    query.append("'");
                    DocumentModelList children = this.session.query(query.toString());
                    if (children != null && !children.isEmpty()) {
                        for (DocumentModel child : children) {
                            this.updateDoc(child);
                        }
                    }
                }
            }
        }

        private DocumentModel getDomain(DocumentModel doc) throws Exception {
            DocumentModel domain = null;
            Filter domainFilter = new Filter(){
                private static final long serialVersionUID = 1L;

                public boolean accept(DocumentModel document) {
                    boolean res = false;
                    if (this.isADomain(document)) {
                        res = true;
                    }
                    return res;
                }

                private boolean isADomain(DocumentModel document) {
                    return "Domain".equals(document.getType());
                }
            };
            DocumentModelList domainList = ToutaticeDocumentHelper.getParentList((CoreSession)this.session, (DocumentModel)doc, (Filter)domainFilter, (boolean)false, (boolean)false, (boolean)true);
            if (domainList.size() == 1) {
                domain = (DocumentModel)domainList.get(0);
                if (domain == null) {
                    log.warn((Object)("Document " + doc.getPathAsString() + " has Domain null: domainId can not be set"));
                }
            } else {
                log.warn((Object)("Document " + doc.getPathAsString() + " has more than one or no Domain: domainId can not be set"));
            }
            return domain;
        }
    }
}

