/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation.transaction;

import fr.toutatice.ecm.platform.automation.transaction.TransactionalConversation;
import fr.toutatice.ecm.platform.automation.transaction.TransactionalConversationPool;
import java.security.Principal;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.transaction.SystemException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;

public class TransactionalConversationManager {
    private static final Log log = LogFactory.getLog(TransactionalConversationManager.class);
    private static final String TXC_ID_PREFIX = "TXC-";
    private static TransactionalConversationManager instance;
    private TransactionalConversationPool txPool = new TransactionalConversationPool();
    private long txCounter = 0L;

    private TransactionalConversationManager() {
    }

    public static synchronized TransactionalConversationManager getInstance() {
        if (instance == null) {
            instance = new TransactionalConversationManager();
        }
        return instance;
    }

    public String start(Principal principal, String repositoryName) throws SystemException {
        String txcId = null;
        ExecutorService executor = Executors.newSingleThreadExecutor();
        TransactionalConversation txConv = new TransactionalConversation(principal, repositoryName, executor);
        Future<Object> future = txConv.getExecutor().submit(txConv);
        try {
            future.get();
            txcId = this.getTxcId(this.txCounter);
            ++this.txCounter;
            txConv.setTxcId(txcId);
            this.txPool.put(txcId, txConv);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new SystemException();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            throw new SystemException();
        }
        return txcId;
    }

    public Object notify(String txId, Object ctx, Object opId, Object params) throws InterruptedException {
        TransactionalConversation txConv = this.getTxConv(txId);
        if (txConv != null) {
            txConv.setOperationContext((OperationContext)ctx);
            txConv.setParams((Map)params);
            txConv.setOperationId((String)opId);
            Future<Object> future = txConv.getExecutor().submit(txConv);
            try {
                Object resultat = future.get();
                if (StringUtils.equals((String)"Repository.CommitOrRollbackTransaction", (String)((String)opId))) {
                    txConv.getExecutor().shutdown();
                    this.txPool.remove(txConv);
                }
                return resultat;
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        } else {
            log.error((Object)("No transaction found with this transaction id:" + txId));
        }
        return null;
    }

    public TransactionalConversation get(String txId) {
        return (TransactionalConversation)this.txPool.get(txId);
    }

    private TransactionalConversation getTxConv(String txId) {
        return (TransactionalConversation)this.txPool.get(txId);
    }

    public String getTxcId(long txc) {
        return TXC_ID_PREFIX + String.valueOf(txc);
    }
}

