/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation.workflows;

import fr.toutatice.ecm.platform.automation.exceptions.WorkflowManagmentException;
import fr.toutatice.ecm.platform.core.helper.ToutaticeWorkflowHelper;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.core.api.DocumentRoutingEngineService;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskImpl;

@Operation(id="Workflow.CancelProcess", category="Services", label="Stop process", since="1.2.2", description="Stop (or cancel) a process bound to the document.")
public class StopWFProcess {
    public static final String ID = "Workflow.CancelProcess";
    @Context
    protected CoreSession documentManager;
    @Context
    protected OperationContext context;
    @Context
    protected transient AutomationService automationService;
    @Context
    protected transient DocumentRoutingEngineService engineRoutingService;
    @Param(name="workflow name", required=true, order=0)
    protected String inputWorkflowName;

    @OperationMethod
    public void run(DocumentModel document) throws Exception {
        Task currentTask;
        DocumentRoute inputWorkflowRoute = ToutaticeWorkflowHelper.getWorkflowByName((String)this.inputWorkflowName, (DocumentModel)document);
        if (inputWorkflowRoute != null) {
            currentTask = this.getCurrentTask(this.inputWorkflowName, this.documentManager, document);
            this.engineRoutingService.cancel(inputWorkflowRoute, this.documentManager);
            if (currentTask == null) {
                throw new WorkflowManagmentException("Workflow " + this.inputWorkflowName + " has no current task");
            }
        } else {
            throw new WorkflowManagmentException("There is no " + this.inputWorkflowName + " workflow instance to cancel");
        }
        ToutaticeWorkflowHelper.notifyRecipients((CoreSession)this.documentManager, (Task)currentTask, (DocumentModel)document, null, (String)"workflowOnlineCanceled");
    }

    private Task getCurrentTask(String wfName, CoreSession session, DocumentModel document) {
        TaskImpl currentTask = null;
        if ("toutatice_online_approbation".equals(wfName)) {
            Task task = ToutaticeWorkflowHelper.getTaskByName((String)"validate-online", (CoreSession)session, (DocumentModel)document);
            currentTask = new TaskImpl(task.getDocument());
        }
        return currentTask;
    }
}

