/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import java.util.List;
import net.sf.json.JSONArray;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.platform.tag.Tag;
import org.nuxeo.ecm.platform.tag.TagService;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Document.GetTags", category="Document", label="Get Document Tags", description="Fetch the document's list of tags. If username is set, only the tags applied by the user are returned. Returns a json array containing the tag labels (string values)")
public class GetDocumentTags {
    public static final String ID = "Document.GetTags";
    private static final Log log = LogFactory.getLog(GetDocumentTags.class);
    @Context
    protected CoreSession session;
    @Param(name="username", description="user who applied the tags", required=false)
    protected String username;

    @OperationMethod
    public Blob run(DocumentModel input) throws Exception {
        TagService service = (TagService)Framework.getLocalService(TagService.class);
        String docId = input.getId();
        log.info((Object)("Document.GetTags> docId=" + docId));
        List existingTags = service.getDocumentTags(this.session, docId, this.username);
        JSONArray jsonTags = new JSONArray();
        for (Tag tag : existingTags) {
            jsonTags.add((Object)tag.getLabel());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Document.GetTags> JSON: " + jsonTags));
        }
        return new StringBlob(jsonTags.toString(), "application/json");
    }
}

