/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Locale;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskService;

@Operation(id="Workflow.GetExtendedTasks", category="Services", label="Get extended tasks", since="5.4", description="List tasks assigned to this user or one of its group.Task properties are serialized using JSON and returned in a Blob.")
public class GetExtendedTasks {
    public static final String ID = "Workflow.GetExtendedTasks";
    private static final Log log = LogFactory.getLog(Log.class);
    @Context
    protected OperationContext ctx;
    @Context
    protected CoreSession repo;
    @Context
    protected TaskService taskService;
    @Param(name="wkflsNames", required=false)
    protected StringList wkfls;

    @OperationMethod
    public Blob run() throws Exception {
        UnrestricedGetExtendedTasks unrestricedGetExtendedTasks = new UnrestricedGetExtendedTasks(this.repo, this.principal(), this.wkfls);
        unrestricedGetExtendedTasks.runUnrestricted();
        return unrestricedGetExtendedTasks.blob;
    }

    protected NuxeoPrincipal principal() {
        return (NuxeoPrincipal)this.ctx.getPrincipal();
    }

    private class UnrestricedGetExtendedTasks
    extends UnrestrictedSessionRunner {
        private NuxeoPrincipal principal;
        public StringBlob blob;
        private CoreSession userSession;
        private StringList wkfls;

        protected UnrestricedGetExtendedTasks(CoreSession session, NuxeoPrincipal principal, StringList wkfls) {
            super(session);
            this.userSession = session;
            this.wkfls = wkfls;
            this.principal = principal;
        }

        public void run() throws ClientException {
            List tasks = GetExtendedTasks.this.taskService.getCurrentTaskInstances(this.userSession);
            if (tasks == null) {
                return;
            }
            JSONArray rows = new JSONArray();
            boolean exposeTask = true;
            for (Task task : tasks) {
                DocumentModel doc = null;
                if (this.wkfls != null && !this.wkfls.isEmpty()) {
                    String wkflName = this.getProcessName(task);
                    exposeTask = this.wkfls.contains((Object)wkflName);
                }
                if (!exposeTask) continue;
                try {
                    if (task.hasEnded().booleanValue() || task.isCancelled().booleanValue()) continue;
                    doc = GetExtendedTasks.this.taskService.getTargetDocumentModel(task, GetExtendedTasks.this.repo);
                }
                catch (Exception e) {
                    log.warn((Object)("Cannot get doc for task " + task.getId() + ", error: " + e.getMessage()));
                }
                if (doc == null) {
                    log.warn((Object)String.format("User '%s' has a task of type '%s' on an unexisting or invisible document", this.principal.getName(), task.getName()));
                    continue;
                }
                if ("deleted".equals(doc.getCurrentLifeCycleState())) continue;
                try {
                    JSONObject obj = new JSONObject();
                    obj.element("docid", (Object)doc.getId());
                    obj.element("doctype", (Object)doc.getType());
                    obj.element("docpath", (Object)doc.getPathAsString());
                    obj.element("docname", (Object)URLEncoder.encode(doc.getTitle(), "UTF-8"));
                    String taskName = I18NUtils.getMessageString((String)"messages", (String)task.getName(), null, (Locale)Locale.FRENCH);
                    obj.element("name", (Object)URLEncoder.encode(taskName, "UTF-8"));
                    obj.element("startDate", (Object)task.getCreated());
                    obj.element("dueDate", (Object)task.getDueDate());
                    rows.add((Object)obj);
                }
                catch (UnsupportedEncodingException e) {
                    throw new ClientException((Throwable)e);
                }
            }
            this.blob = 0 < rows.size() ? new StringBlob(rows.toString(), "application/json") : null;
        }

        private String getProcessName(Task task) {
            DocumentModel processDoc;
            String name = null;
            String processId = task.getProcessId();
            if (StringUtils.isNotBlank((String)processId) && (name = (processDoc = ToutaticeDocumentHelper.getUnrestrictedDocument((CoreSession)GetExtendedTasks.this.repo, (String)processId)).getName()).contains(".")) {
                name = name.substring(0, name.indexOf(46));
            }
            return name;
        }
    }
}

