/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDirectoryMngtHelper;
import java.io.Serializable;
import java.net.URLEncoder;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;

@Operation(id="Document.GetVocabularies", category="Services", label="Get Vocabularies", since="5.4", description="Vocabularies are serialized using JSON and returned in a Blob.")
public class GetVocabularies {
    public static final String ID = "Document.GetVocabularies";
    private static final Log log = LogFactory.getLog(GetVocabularies.class);
    private static final Long NOT_OBSOLETE = new Long(0L);
    @Param(name="vocabularies", required=true)
    protected String vocabularies;
    @Param(name="locale", required=false)
    protected String locale;
    private ArrayList<String> indexVoc;
    private ArrayList<VocabularyEntry> listValVoc;
    private HashMap<String, ArrayList<VocabularyEntry>> listVoc;

    @OperationMethod
    public Blob run() throws Exception {
        DocumentModelList entries = null;
        Locale localeChoisie = null;
        localeChoisie = StringUtils.isNotBlank((String)this.locale) ? new Locale(this.locale) : Locale.FRENCH;
        this.listVoc = new HashMap();
        this.indexVoc = new ArrayList();
        StringTokenizer parVocToken = new StringTokenizer(this.vocabularies, ";");
        while (parVocToken.hasMoreTokens()) {
            String voc = parVocToken.nextToken();
            this.indexVoc.add(voc);
            entries = ToutaticeDirectoryMngtHelper.instance().getEntries(voc);
            this.listValVoc = new ArrayList();
            for (DocumentModel entry : entries) {
                VocabularyEntry ve = new VocabularyEntry(voc, localeChoisie, entry);
                if (!ve.getObsolete().equals(NOT_OBSOLETE)) continue;
                this.listValVoc.add(ve);
            }
            Collections.sort(this.listValVoc, new VocabularyEntryComparator());
            this.listVoc.put(voc, this.listValVoc);
        }
        JSONArray rows = this.getChildren(null, 0);
        if (log.isDebugEnabled()) {
            log.debug((Object)("JSON: " + rows));
        }
        return new StringBlob(rows.toString(), "application/json");
    }

    private JSONArray getChildren(String key, int i) {
        JSONArray rows = new JSONArray();
        String voc = "";
        if (i < this.indexVoc.size()) {
            voc = this.indexVoc.get(i);
            ArrayList<VocabularyEntry> entries = this.listVoc.get(voc);
            ++i;
            for (VocabularyEntry entry : entries) {
                String valkey = entry.getTitle();
                String vali18n = entry.getLabel();
                String valparent = entry.getParent();
                if (key != null && !key.equalsIgnoreCase(valparent)) continue;
                JSONObject obj = new JSONObject();
                obj.element("key", (Object)valkey);
                obj.element("value", (Object)vali18n);
                obj.element("parent", (Object)valparent);
                if (i != this.indexVoc.size()) {
                    obj.element("children", (Collection)this.getChildren(valkey, i));
                }
                rows.add((Object)obj);
            }
        }
        return rows;
    }

    private class VocabularyEntryComparator
    implements Comparator<VocabularyEntry>,
    Serializable {
        private static final long serialVersionUID = 3330267100994507692L;
        private Collator collator = Collator.getInstance();

        public VocabularyEntryComparator() {
            this.collator.setDecomposition(1);
            this.collator.setStrength(2);
        }

        @Override
        public int compare(VocabularyEntry e1, VocabularyEntry e2) {
            int status = 0;
            status = e1.getOrdering().compareTo(e2.getOrdering());
            if (0 == status) {
                status = this.collator.compare(e1.getLabel(), e2.getLabel());
            }
            return status;
        }
    }

    private class VocabularyEntry {
        private String title;
        private String label;
        private String parent;
        private Long ordering;
        private Long obsolete;

        public VocabularyEntry(String vocabulary, Locale locale, DocumentModel entry) throws ClientException {
            try {
                String schema = this.getDirectorySchema(entry);
                this.ordering = (Long)entry.getProperty(schema, "ordering");
                this.obsolete = (Long)entry.getProperty(schema, "obsolete");
                this.title = URLEncoder.encode(entry.getTitle(), "UTF-8");
                String localizedEntryLabel = ToutaticeDirectoryMngtHelper.instance().getDirectoryEntryLocalizedLabel(vocabulary, entry.getId(), locale);
                this.label = URLEncoder.encode(localizedEntryLabel, "UTF-8");
                try {
                    this.parent = (String)entry.getProperty(schema, "parent");
                }
                catch (Exception e) {
                    this.parent = "";
                }
            }
            catch (Exception e) {
                log.error((Object)("Failed to instanciate VocabularyEntry, vocabulary:'" + vocabulary + "', entry:'" + entry.getId() + "', error:" + e.getMessage()));
                throw new ClientException((Throwable)e);
            }
        }

        public String getTitle() {
            return this.title;
        }

        public String getLabel() {
            return this.label;
        }

        public String getParent() {
            return this.parent;
        }

        public Long getOrdering() {
            return this.ordering;
        }

        public Long getObsolete() {
            return this.obsolete;
        }

        private String getDirectorySchema(DocumentModel entry) {
            String schema = null;
            String[] schemaList = entry.getSchemas();
            if (null != schemaList && 0 < schemaList.length) {
                schema = schemaList[0];
            }
            return schema;
        }

        public String toString() {
            return "{parent:" + this.getParent() + ", title:" + this.getTitle() + ", label:" + this.getLabel() + ", ordering:" + this.getOrdering() + ", obsolete:" + !this.getObsolete().equals(NOT_OBSOLETE) + "}";
        }
    }
}

