/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;

@Operation(id="Document.RemovePublishedVersions", category="Document", label="Remove all published versions of a document", description="Remove all published versions of a document among its versions series and inside a specific target folder/section. Return the input document.")
public class RemovePublishedVersions {
    public static final String ID = "Document.RemovePublishedVersions";
    @Context
    protected CoreSession session;
    @Param(name="target", required=true)
    protected DocumentModel target;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel document) throws Exception {
        UnrestrictedRemovePublishedVersionsRunner removeRunner = new UnrestrictedRemovePublishedVersionsRunner(this.session, document, this.target);
        removeRunner.runUnrestricted();
        return removeRunner.getReturnedDocument();
    }

    private static class UnrestrictedRemovePublishedVersionsRunner
    extends UnrestrictedSessionRunner {
        private DocumentModel document;
        private DocumentModel target;
        private DocumentModel returnedDocument;

        public DocumentModel getReturnedDocument() {
            return this.returnedDocument;
        }

        public UnrestrictedRemovePublishedVersionsRunner(CoreSession session, DocumentModel document, DocumentModel target) {
            super(session);
            this.document = document;
            this.target = target;
        }

        public void run() throws ClientException {
            DocumentRef targetRef = this.target.getRef();
            DocumentRef baseDocRef = this.document.getRef();
            this.returnedDocument = this.document;
            if (this.document.isVersion()) {
                String sourceDocId = this.document.getSourceId();
                baseDocRef = new IdRef(sourceDocId);
            }
            if (this.document.isProxy()) {
                this.returnedDocument = this.target;
            }
            if (null != targetRef) {
                DocumentModelList proxies = this.session.getProxies(baseDocRef, targetRef);
                for (DocumentModel proxy : proxies) {
                    this.session.removeDocument(proxy.getRef());
                }
            } else {
                throw new ClientException("Failed to get the target document reference");
            }
        }
    }
}

