/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;

@Operation(id="Document.SetACL", category="Document", label="Set complete ACL", description="Set the complete Acces Control List on the input document(s). Parameters: 'acl' is the name of the access control list to set ('local' as default). Set 'break' to true if you want to break rights inheritance. 'entries' must respect the format '<principal>:<permission>:<grant>,<principal>:<permission>:<grant>,...'. . As default, the ACL list is overwritten. Returns the document(s).")
public class SetDocumentACL {
    private static final Log log = LogFactory.getLog(SetDocumentACL.class);
    public static final String ID = "Document.SetACL";
    public static final String ACE_DELIMITER = ",";
    public static final String VALUE_DELIMITER = ":";
    @Context
    protected CoreSession session;
    @Param(name="acl", required=false, values={"local"})
    String aclName = "local";
    @Param(name="entries")
    protected String entries;
    @Param(name="overwrite", required=false, values={"false,true"})
    boolean doOverwrite = true;
    @Param(name="break", required=false, values={"false,true"})
    boolean doBreakInheritance = false;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) throws Exception {
        this.setACE(doc.getRef());
        return this.session.getDocument(doc.getRef());
    }

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentRef doc) throws Exception {
        this.setACE(doc);
        return this.session.getDocument(doc);
    }

    protected void setACE(DocumentRef ref) throws ClientException {
        List<ACE>[] aceList = this.slurpACEs(this.entries);
        ACP acp = this.session.getACP(ref);
        ACLImpl acl = (ACLImpl)acp.getACL(this.aclName);
        if (acl == null || this.doOverwrite) {
            acl = new ACLImpl(this.aclName);
            acl.addAll(aceList[0]);
        } else {
            for (ACE ace : aceList[0]) {
                if (acl.contains((Object)ace)) continue;
                acl.add(0, (Object)ace);
            }
        }
        acl.removeAll(aceList[1]);
        acp.addACL((ACL)acl);
        this.session.setACP(ref, acp, this.doOverwrite);
    }

    private List<ACE>[] slurpACEs(String entries) {
        ArrayList[] tabList = new ArrayList[2];
        ArrayList<ACE> lstAcePos = new ArrayList<ACE>();
        ArrayList<ACE> lstAceNeg = new ArrayList<ACE>();
        StringTokenizer aceTokenizer = new StringTokenizer(entries, ACE_DELIMITER);
        while (aceTokenizer.hasMoreTokens()) {
            String aceStg = aceTokenizer.nextToken();
            Pattern p = Pattern.compile("^(.+?):(.+?):(.+?)$");
            Matcher m = p.matcher(aceStg);
            if (m.find()) {
                String user = m.group(1);
                String permission = m.group(2);
                boolean granted = Boolean.parseBoolean(m.group(3));
                ACE ace = new ACE(user, permission, true);
                if (granted) {
                    lstAcePos.add(ace);
                    continue;
                }
                lstAceNeg.add(ace);
                continue;
            }
            log.warn((Object)("ACE doesn't respect the format <principal>:<permission>:<grant>, entry='" + aceStg + "'"));
        }
        if (this.doBreakInheritance) {
            lstAcePos.add(new ACE("Everyone", "Everything", false));
        }
        tabList[0] = lstAcePos;
        tabList[1] = lstAceNeg;
        return tabList;
    }
}

