/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import fr.toutatice.ecm.platform.core.helper.ToutaticeNotifyEventHelper;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.InvalidChainException;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Document.SetOnLineOperation", category="Document", label="Set on line a document", description="Set on line a document (publish locally, acl copy).")
public class SetOnLine {
    public static final String ID = "Document.SetOnLineOperation";
    public static final String CHAIN_ID = "Document.SetOnLineChain";
    public static final String CHAIN_LOG_ID = "Log";
    public static final String DOCUMENT_SET_ON_LINE_EVENT = "documentSetOnLine";
    @Context
    protected CoreSession session;

    @OperationMethod
    public DocumentModel run(DocumentModel doc) throws Exception {
        UnrestrictedSetOnLineRunner setOnLineRunner = new UnrestrictedSetOnLineRunner(this.session, doc);
        setOnLineRunner.runUnrestricted();
        ToutaticeNotifyEventHelper.notifyEvent((CoreSession)this.session, (String)DOCUMENT_SET_ON_LINE_EVENT, (DocumentModel)doc, null);
        this.logAudit(doc);
        return setOnLineRunner.getDocument();
    }

    private static void runChain(CoreSession session, DocumentModel doc, OperationChain logChain) throws Exception, OperationException, InvalidChainException {
        AutomationService automationService = (AutomationService)Framework.getService(AutomationService.class);
        OperationContext context = new OperationContext(session);
        context.setInput((Object)doc);
        automationService.run(context, logChain);
    }

    private void logAudit(DocumentModel doc) throws InvalidChainException, OperationException, Exception {
        OperationChain logChain = new OperationChain(CHAIN_LOG_ID);
        OperationParameters logOpParam = new OperationParameters("Audit.Log");
        logOpParam.set("event", (Object)"Mise en ligne");
        logOpParam.set("category", (Object)"Automation");
        logOpParam.set("comment", (Object)("Version " + doc.getVersionLabel()));
        logChain.add(logOpParam);
        SetOnLine.runChain(this.session, doc, logChain);
    }

    private static class UnrestrictedSetOnLineRunner
    extends UnrestrictedSessionRunner {
        private DocumentModel document;

        public DocumentModel getDocument() {
            return this.document;
        }

        public UnrestrictedSetOnLineRunner(CoreSession session, DocumentModel document) {
            super(session);
            this.document = document;
        }

        public void run() throws ClientException {
            OperationChain onLineChain = new OperationChain(SetOnLine.CHAIN_ID);
            OperationParameters publishOpParam = new OperationParameters("Document.TTCPPublish");
            DocumentModel parentDoc = this.session.getParentDocument(this.document.getRef());
            publishOpParam.set("target", (Object)parentDoc);
            publishOpParam.set("override", (Object)true);
            onLineChain.add(publishOpParam);
            OperationParameters copyAclsOpParam = new OperationParameters("Document.CopyACLs");
            copyAclsOpParam.set("the source document", (Object)this.document);
            copyAclsOpParam.set("Copy all ACLs", (Object)true);
            copyAclsOpParam.set("Overwrite", (Object)true);
            onLineChain.add(copyAclsOpParam);
            try {
                SetOnLine.runChain(this.session, this.document, onLineChain);
            }
            catch (Exception e) {
                throw new ClientException((Throwable)e);
            }
        }
    }
}

