/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation.workflows;

import fr.toutatice.ecm.platform.core.helper.ToutaticeWorkflowHelper;
import java.security.Principal;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskImpl;
import org.nuxeo.ecm.platform.task.TaskService;

@Operation(id="Workflow.OperateProcess", category="Services", label="Operate an action on the process", since="5.3.2", description="Permit to operate an action (validate, reject) on the process bound to the document.")
public class OperateWFProcess {
    public static final String ID = "Workflow.OperateProcess";
    @Context
    protected CoreSession coreSession;
    @Context
    protected transient DocumentRoutingService routingService;
    @Context
    protected transient TaskService taskService;
    @Param(name="task name", required=true, order=0)
    protected String taskName;
    @Param(name="transition", required=false, order=1)
    protected String transition;
    @Param(name="comment", required=false, order=3)
    protected String comment;

    @OperationMethod
    public DocumentModel run(DocumentModel document) throws Exception {
        Task task = ToutaticeWorkflowHelper.getTaskByName((String)this.taskName, (CoreSession)this.coreSession, (DocumentModel)document);
        TaskImpl taskForNotif = new TaskImpl(task.getDocument());
        String initiator = ToutaticeWorkflowHelper.getOnLineWorkflowInitiator((DocumentModel)document);
        if (StringUtils.isNotBlank((String)this.comment)) {
            Principal principal = this.coreSession.getPrincipal();
            task.addComment(principal.getName(), this.comment);
        }
        this.routingService.endTask(this.coreSession, task, new HashMap(0), this.transition);
        ToutaticeWorkflowHelper.notifyRecipients((CoreSession)this.coreSession, (Task)taskForNotif, (DocumentModel)document, (String)initiator, (String)this.getEvent(this.transition));
        return document;
    }

    protected String getEvent(String transition) {
        String event = "";
        event = "workflow_online_accept".equals(transition) ? "workflowOnlineTaskApproved" : "workflowOnlineTaskRejected";
        return event;
    }
}

