/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.opentoutatice.sharing.elasticsearch;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.core.HttpHeaders;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.automation.jaxrs.io.documents.JsonESDocumentWriter;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;

public class SharingJsonESDocumentWriter
extends JsonESDocumentWriter {
    public void writeDoc(JsonGenerator jsonGenerator, DocumentModel document, String[] schemas, Map<String, String> contextParameters, HttpHeaders headers) throws IOException {
        if (document.hasFacet("Sharing")) {
            jsonGenerator.writeStartObject();
            this.writeSharingProperties(jsonGenerator, document);
            this.writeSystemProperties(jsonGenerator, document);
            this.writeSchemas(jsonGenerator, document, schemas);
            this.writeContextParameters(jsonGenerator, document, contextParameters);
            jsonGenerator.writeEndObject();
            jsonGenerator.flush();
        } else {
            super.writeDoc(jsonGenerator, document, schemas, contextParameters, headers);
        }
    }

    private void writeSharingProperties(JsonGenerator jsonGenerator, DocumentModel document) throws IOException {
        ACP acp = document.getACP();
        ACL acl = acp.getACL("sharing");
        jsonGenerator.writeArrayFieldStart("sharing:users");
        if (CollectionUtils.isNotEmpty((Collection)acl)) {
            for (ACE ace : acl) {
                String user = ace.getUsername();
                if (!StringUtils.isNotEmpty((String)user)) continue;
                jsonGenerator.writeString(user);
            }
        }
        jsonGenerator.writeEndArray();
    }
}

