/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.service.editablewindows.types;

import fr.toutatice.ecm.platform.service.editablewindows.EwServiceException;
import fr.toutatice.ecm.platform.service.editablewindows.types.EditableWindow;
import fr.toutatice.ecm.platform.service.fragments.configuration.ConfigurationBeanHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;

public class FragmentEditableWindow
implements EditableWindow {
    private static final String SCHEMA = "ew_fragments";
    private static final String FRAGMENT_PROPERTIES = "ew_fragments_properties";

    @Override
    public String prepareCreation(DocumentModel doc, String uri, String region, String belowUri, String code2) throws EwServiceException {
        try {
            Map fProperties;
            Map schema = doc.getProperties(SCHEMA);
            Collection values = schema.values();
            Object liste = values.iterator().next();
            if (liste instanceof List) {
                List listeData = (List)liste;
                HashMap<String, String> newEntry = new HashMap<String, String>();
                newEntry.put("refURI", uri);
                newEntry.put("portalFragmentName", code2);
                listeData.add(newEntry);
                doc.setProperties(SCHEMA, schema);
            }
            if ((liste = (values = (fProperties = doc.getProperties(FRAGMENT_PROPERTIES)).values()).iterator().next()) instanceof List) {
                List listeData = (List)liste;
                ConfigurationBeanHelper configBean = ConfigurationBeanHelper.getBean();
                List options = configBean.getFragmentOptionsByCode(doc, code2);
                if (options != null) {
                    for (Map option : options) {
                        HashMap<String, String> newEntry = new HashMap<String, String>();
                        newEntry.put("refURI", uri);
                        newEntry.put("key", (String)option.get("propertyName"));
                        newEntry.put("value", (String)option.get("propertyDefaultValue"));
                        newEntry.put("editable", (String)option.get("propertyEditable"));
                        newEntry.put("label", (String)option.get("propertyLabel"));
                        listeData.add(newEntry);
                    }
                    doc.setProperties(FRAGMENT_PROPERTIES, fProperties);
                }
            }
        }
        catch (ClientException e) {
            throw new EwServiceException((Exception)((Object)e));
        }
        return uri;
    }
}

