/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.mode.bean;

import fr.toutatice.ecm.platform.web.mode.service.SegmentService;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;

@Name(value="webModeValidator")
@Scope(value=ScopeType.SESSION)
@Install(precedence=31)
public class WebModeValidatorBean
implements Serializable {
    private static final long serialVersionUID = 5623376301895535136L;
    private static final Pattern patternSegment = Pattern.compile("([a-z_0-9\\-]+)");
    @In(create=true, required=true)
    protected transient CoreSession documentManager;
    @In(create=true, required=true)
    protected NavigationContext navigationContext;
    @In(create=true)
    protected SegmentService segmentService;

    public void validateSegment(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (StringUtils.isNotBlank((String)((String)value))) {
            Matcher m = patternSegment.matcher((String)value);
            if (!m.matches()) {
                String msg = ComponentUtils.translate((FacesContext)context, (String)"webmode.validator.malformed.segment");
                FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, null);
                throw new ValidatorException(message);
            }
            if (!this.validateUnicity((String)value)) {
                String msg = ComponentUtils.translate((FacesContext)context, (String)"webmode.validator.existing.segment");
                FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, null);
                throw new ValidatorException(message);
            }
        }
    }

    public boolean validateUnicity(String value) {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        return this.segmentService.isUniqueSegment(this.documentManager, doc, value);
    }
}

