/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.mode.listener;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeSilentProcessRunnerHelper;
import fr.toutatice.ecm.platform.web.mode.service.SegmentService;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.EventImpl;
import org.nuxeo.runtime.api.Framework;

public class SetSegmentListener
implements EventListener {
    public void handleEvent(Event event) throws ClientException {
        SegmentService segmentService = (SegmentService)((Object)Framework.getService(SegmentService.class));
        DocumentEventContext evtCtx = (DocumentEventContext)event.getContext();
        DocumentModel sourceDocument = evtCtx.getSourceDocument();
        CoreSession session = evtCtx.getCoreSession();
        if ("beforeDocumentModification".equals(event.getName()) && "PortalSite".equals(sourceDocument.getType())) {
            Property webUrlsEnabledProp = sourceDocument.getProperty("ottcwebc:enableWebUrl");
            if (webUrlsEnabledProp.isDirty() && BooleanUtils.isTrue((Boolean)((Boolean)webUrlsEnabledProp.getValue()))) {
                this.setSegment(session, segmentService, sourceDocument, true);
                DocumentEventContext ctx = new DocumentEventContext(session, evtCtx.getPrincipal(), session.getDocument(sourceDocument.getRef()));
                EventImpl redirectEvent = new EventImpl("beforeDocumentModification", (EventContext)ctx);
                ((EventService)Framework.getLocalService(EventService.class)).fireEvent((Event)redirectEvent);
            }
        } else if (!"beforeDocumentModification".equals(event.getName()) && segmentService.supportsWebUrls(session, sourceDocument) && !sourceDocument.isProxy() && !"documentMoved".equals(event.getName())) {
            this.setSegment(session, segmentService, sourceDocument, true);
        }
    }

    protected void setSegment(CoreSession session, SegmentService segmentService, DocumentModel sourceDocument, boolean versioning) {
        String segment = segmentService.createSegment(session, sourceDocument);
        sourceDocument.setPropertyValue("ottcweb:segment", (Serializable)((Object)segment));
        if (versioning) {
            ToutaticeDocumentHelper.saveDocumentSilently((CoreSession)session, (DocumentModel)sourceDocument, (List)ToutaticeSilentProcessRunnerHelper.DEFAULT_FILTERED_SERVICES_LIST, (boolean)false);
        } else {
            ToutaticeDocumentHelper.saveDocumentSilently((CoreSession)session, (DocumentModel)sourceDocument, (boolean)false);
        }
    }
}

