/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.cas.adaptors.ldap;

import java.text.ParseException;
import java.util.Date;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.api.util.GeneralizedTime;
import org.jasig.cas.adaptors.ldap.AbstractLdapUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.principal.UsernamePasswordCredentials;
import org.jasig.cas.util.LdapUtils;

public class UsernamePasswordAuthenticationHandler
extends AbstractLdapUsernamePasswordAuthenticationHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean authenticateUsernamePasswordInternal(UsernamePasswordCredentials credentials) throws AuthenticationException {
        boolean result;
        credentials.setUsername(StringUtils.lowerCase((String)credentials.getUsername()));
        DirContext dirContext = null;
        try {
            String transformedUsername = this.getPrincipalNameTransformer().transform(credentials.getUsername());
            String bindDn = LdapUtils.getFilterWithValues((String)this.getFilter(), (String)transformedUsername);
            dirContext = this.getContextSource().getContext(bindDn, credentials.getPassword());
            Attributes attributes = dirContext == null ? null : dirContext.getAttributes(bindDn);
            Attribute externalAttribute = attributes == null ? null : attributes.get("portalPersonExternal");
            if (externalAttribute != null && externalAttribute.get() != null && BooleanUtils.toBoolean((String)externalAttribute.get().toString())) {
                result = false;
            } else {
                Date validity;
                Attribute validityAttribute = attributes == null ? null : attributes.get("portalPersonValidity");
                if (validityAttribute == null) {
                    validity = null;
                } else {
                    String validityValue = (String)validityAttribute.get();
                    try {
                        GeneralizedTime generalizedTime = new GeneralizedTime(validityValue);
                        validity = generalizedTime.getDate();
                    }
                    catch (ParseException e) {
                        validity = null;
                    }
                }
                result = validity == null ? true : validity.after(new Date());
            }
            if (dirContext == null) return result;
        }
        catch (Exception e) {
            result = false;
            return result;
        }
        finally {
            if (dirContext != null) {
                LdapUtils.closeContext(dirContext);
            }
        }
        LdapUtils.closeContext((DirContext)dirContext);
        return result;
    }
}

