/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.cas.fim;

import java.util.HashMap;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.CredentialsToPrincipalResolver;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.SimplePrincipal;
import org.osivia.cas.fim.FimCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FimCredentialsToPrincipalResolver
implements CredentialsToPrincipalResolver {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public boolean supports(Credentials credentials) {
        return credentials instanceof FimCredentials;
    }

    public final Principal resolvePrincipal(Credentials credentials) {
        FimCredentials fimCredentials;
        String principalId;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Attempting to resolve a principal...");
        }
        if ((principalId = (fimCredentials = (FimCredentials)credentials).getUsername()) == null) {
            return null;
        }
        principalId = principalId.toLowerCase();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Creating SimplePrincipal for [" + principalId + "]");
        }
        HashMap convertedAttributes = new HashMap();
        convertedAttributes.putAll(fimCredentials.getAttributes());
        return new SimplePrincipal(principalId, convertedAttributes);
    }
}

