/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.identity.sso.cas;

import java.util.Set;
import javax.naming.InitialContext;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.jboss.portal.identity.MembershipModule;
import org.jboss.portal.identity.Role;
import org.jboss.portal.identity.User;
import org.jboss.portal.identity.UserModule;
import org.jboss.portal.identity.UserProfileModule;
import org.jboss.portal.identity.sso.AuthenticationService;

public class CASAuthenticationService
implements AuthenticationService {
    private static Logger log = Logger.getLogger(CASAuthenticationService.class);
    private UserModule userModule = null;
    private UserProfileModule profileModule = null;
    private MembershipModule membershipModule = null;
    private String havingRole = null;

    public void start() {
        try {
            InitialContext initialContext = new InitialContext();
            this.userModule = (UserModule)initialContext.lookup("java:/portal/UserModule");
            this.profileModule = (UserProfileModule)initialContext.lookup("java:/portal/UserProfileModule");
            this.membershipModule = (MembershipModule)initialContext.lookup("java:/portal/MembershipModule");
        }
        catch (Exception e) {
            log.error((Object)this, (Throwable)e);
            this.stop();
        }
    }

    public void stop() {
        this.userModule = null;
        this.profileModule = null;
        this.membershipModule = null;
        this.havingRole = null;
    }

    public String getHavingRole() {
        return this.havingRole;
    }

    public void setHavingRole(String havingRole) {
        this.havingRole = havingRole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(String username, String password) {
        Session session = null;
        Transaction tx = null;
        try {
            Boolean enabled;
            boolean status = false;
            InitialContext initialContext = new InitialContext();
            SessionFactory sessionFactory = (SessionFactory)initialContext.lookup("java:/portal/IdentitySessionFactory");
            session = sessionFactory.openSession();
            tx = session.beginTransaction();
            User user = this.userModule.findUserByUserName(username);
            if (user != null && (enabled = (Boolean)this.profileModule.getProperty(user, "portal.user.enabled")) != null && enabled.booleanValue()) {
                if (this.havingRole != null && this.havingRole.trim().length() > 0) {
                    boolean hasTheRole = false;
                    Set roles = this.membershipModule.getRoles(user);
                    for (Role role : roles) {
                        if (!this.havingRole.equals(role.getName())) continue;
                        hasTheRole = true;
                        break;
                    }
                    if (!hasTheRole) {
                        boolean bl = false;
                        return bl;
                    }
                }
                status = user.validatePassword(password);
            }
            boolean bl = status;
            return bl;
        }
        catch (Exception e) {
            log.error((Object)this, (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            tx.commit();
            session.close();
        }
    }
}

