/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.identity.sso.cas;

import edu.yale.its.tp.cas.client.CASAuthenticationException;
import edu.yale.its.tp.cas.client.CASReceipt;
import edu.yale.its.tp.cas.client.ProxyTicketValidator;
import edu.yale.its.tp.cas.client.Util;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Context;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.log4j.Logger;
import org.jboss.portal.identity.helper.IdentityTools;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.login.IUserDatasModuleRepository;
import org.osivia.portal.api.login.UserDatasModuleMetadatas;

public class CASAuthenticationValve
extends ValveBase {
    private static final int HTTPS_PORT = 443;
    private static final int HTTP_PORT = 80;
    private static final String UTF_8 = "UTF-8";
    public static final String VIRTUAL_HOST_REQUEST_HEADER = "osivia-virtual-host";
    private static final String SEP = ":";
    private static final Logger log = Logger.getLogger((String)"valve");
    public static final String LOGIN_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.loginUrl";
    public static final String VALIDATE_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.validateUrl";
    public static final String SERVICE_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.serviceUrl";
    public static final String SERVERNAME_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.serverName";
    public static final String RENEW_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.renew";
    public static final String AUTHORIZED_PROXY_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.authorizedProxy";
    public static final String PROXY_CALLBACK_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.proxyCallbackUrl";
    public static final String WRAP_REQUESTS_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.wrapRequest";
    public static final String GATEWAY_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.gateway";
    public static final String CAS_FILTER_USER = "edu.yale.its.tp.cas.client.filter.user";
    public static final String CAS_FILTER_RECEIPT = "edu.yale.its.tp.cas.client.filter.receipt";
    private String casLogin;
    private String casLogout;
    private String casValidate;
    private String casServiceUrl;
    private String casServerName;
    private String casProxyCallbackUrl;
    private boolean casRenew;
    private final boolean casGateway = false;
    private final List authorizedProxies = new ArrayList();
    private Set urlPatterns;
    private String authType = null;
    private String fileEncoding = System.getProperty("file.encoding");
    private IUserDatasModuleRepository userModuleRepo = (IUserDatasModuleRepository)Locator.findMBean(IUserDatasModuleRepository.class, (String)"osivia:service=Interceptor,type=Server,name=ServerLogin");

    public String getCasLogin() {
        return this.casLogin;
    }

    public void setCasLogin(String casLogin) {
        this.casLogin = casLogin;
    }

    public String getCasLogout() {
        return this.casLogout;
    }

    public void setCasLogout(String casLogout) {
        this.casLogout = casLogout;
    }

    public String getCasServerName() {
        return this.casServerName;
    }

    public void setCasServerName(String casServerName) {
        this.casServerName = casServerName;
    }

    public String getCasValidate() {
        return this.casValidate;
    }

    public void setCasValidate(String casValidate) {
        this.casValidate = casValidate;
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getCasServiceUrl() {
        return this.casServiceUrl;
    }

    public void setCasServiceUrl(String casServiceUrl) {
        this.casServiceUrl = casServiceUrl;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        String requestURI;
        Request httpRequest = request;
        HttpSession session = httpRequest.getSession();
        request.setAttribute("ssoEnabled", (Object)"true");
        if (this.fileEncoding != null) {
            request.setCharacterEncoding(this.fileEncoding);
        }
        if (this.isSecuredURI(requestURI = request.getRequestURI()) && request.getParameter("ticket") == null && session.getAttribute(CAS_FILTER_USER) == null) {
            this.redirectToCAS((HttpServletRequest)request, (HttpServletResponse)response);
            return;
        }
        if (request.getParameter("ticket") != null && session.getAttribute(CAS_FILTER_USER) == null) {
            boolean skip;
            CASReceipt receipt;
            block10: {
                receipt = null;
                skip = false;
                try {
                    receipt = this.getAuthenticatedUser((HttpServletRequest)httpRequest);
                }
                catch (CASAuthenticationException e) {
                    skip = true;
                    if (!log.isDebugEnabled()) break block10;
                    log.error((Object)"Authentification failed", (Throwable)e);
                }
            }
            if (!skip && !this.isReceiptAcceptable(receipt)) {
                skip = true;
            }
            if (!skip) {
                session.setAttribute(CAS_FILTER_USER, (Object)receipt.getUserName());
                session.setAttribute(CAS_FILTER_RECEIPT, (Object)receipt);
                String user = receipt.getUserName();
                request.setAttribute("ssoSuccess", (Object)new Boolean(true));
                Principal principal = ((Context)this.container).getRealm().authenticate(user, (String)null);
                if (principal != null) {
                    this.register(request, response, principal, this.authType, user, null);
                } else {
                    UserDatasModuleMetadatas feeder = this.userModuleRepo.getModule("LDAPFEEDER");
                    feeder.getModule().computeUser(user);
                    principal = ((Context)this.container).getRealm().authenticate(user, (String)null);
                    if (principal != null) {
                        this.register(request, response, principal, this.authType, user, null);
                    }
                }
            }
        }
        this.getNext().invoke(request, response);
    }

    private void register(Request request, Response response, Principal principal, String authType, String username, String password) {
        request.setAuthType(authType);
        request.setUserPrincipal(principal);
        Session session = request.getSessionInternal(false);
        if (session != null) {
            session.setAuthType(authType);
            session.setPrincipal(principal);
            if (username != null) {
                session.setNote("org.apache.catalina.session.USERNAME", (Object)username);
            } else {
                session.removeNote("org.apache.catalina.session.USERNAME");
            }
            if (password != null) {
                session.setNote("org.apache.catalina.session.PASSWORD", (Object)password);
            } else {
                session.removeNote("org.apache.catalina.session.PASSWORD");
            }
        }
    }

    private boolean isReceiptAcceptable(CASReceipt receipt) {
        if (receipt == null) {
            throw new IllegalArgumentException("Cannot evaluate a null receipt.");
        }
        if (this.casRenew && !receipt.isPrimaryAuthentication()) {
            return false;
        }
        return !receipt.isProxied() || this.authorizedProxies.contains(receipt.getProxyingService());
    }

    private CASReceipt getAuthenticatedUser(HttpServletRequest request) throws ServletException, CASAuthenticationException {
        ProxyTicketValidator pv = null;
        pv = new ProxyTicketValidator();
        pv.setCasValidateUrl(this.casValidate);
        pv.setServiceTicket(request.getParameter("ticket"));
        pv.setService(this.getService(request));
        pv.setRenew(Boolean.valueOf(this.casRenew).booleanValue());
        if (this.casProxyCallbackUrl != null) {
            pv.setProxyCallbackUrl(this.casProxyCallbackUrl);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getAuthenticatedUser -> try to validate the ticket " + pv.toString()));
        }
        return CASReceipt.getReceipt((ProxyTicketValidator)pv);
    }

    private void redirectToCAS(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String casLoginString = this.casLogin + "?service=" + this.getService(request) + (this.casRenew ? "&renew=true" : "") + "";
        response.sendRedirect(casLoginString);
    }

    private String getService(HttpServletRequest request) throws ServletException {
        String serviceString;
        if (log.isDebugEnabled()) {
            log.debug((Object)"redirectToCAS -> entering getService...");
        }
        String header = request.getHeader(VIRTUAL_HOST_REQUEST_HEADER);
        String currentServerName = request.getServerName();
        if (request.getServerPort() != 80 && request.getServerPort() != 443) {
            currentServerName = currentServerName.concat(SEP).concat(Integer.toString(request.getServerPort()));
        }
        if (this.casServerName == null && this.casServiceUrl == null) {
            throw new ServletException("need one of the following configuration parameters: edu.yale.its.tp.cas.client.filter.serviceUrl or edu.yale.its.tp.cas.client.filter.serverName");
        }
        try {
            if (this.casServiceUrl != null) {
                serviceString = URLEncoder.encode(this.casServiceUrl, UTF_8);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("use the given string casServiceUrl : " + serviceString));
                }
            } else if (header != null) {
                serviceString = URLEncoder.encode(header, UTF_8);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("use the url given by front web server: " + serviceString));
                }
            } else if (currentServerName != null) {
                serviceString = Util.getService((HttpServletRequest)request, (String)currentServerName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("try to build service url with the request : " + serviceString));
                }
            } else {
                serviceString = Util.getService((HttpServletRequest)request, (String)this.casServerName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("default case, return our best guess at the service : " + serviceString));
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new ServletException((Throwable)e);
        }
        return serviceString;
    }

    private boolean isSecuredURI(String uri) {
        Set patterns = this.getSecuredUrlPatterns();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking if requested uri '" + uri + "' matches secured url patterns: " + patterns));
        }
        for (String pattern : patterns) {
            if (uri.indexOf(pattern) == -1) continue;
            return true;
        }
        return false;
    }

    public Set getSecuredUrlPatterns() {
        if (this.urlPatterns == null) {
            this.urlPatterns = IdentityTools.findSecuredURLs((Context)((Context)this.container));
            HashSet<String> urls = new HashSet<String>();
            for (String pattern : this.urlPatterns) {
                urls.add(pattern.replaceAll("\\*", ""));
            }
            this.urlPatterns = urls;
        }
        return this.urlPatterns;
    }
}

