/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.demo.customizer.plugin;

import fr.toutatice.portail.cms.nuxeo.api.domain.AbstractPluginPortlet;
import fr.toutatice.portail.cms.nuxeo.api.domain.ListTemplate;
import fr.toutatice.portail.cms.nuxeo.api.portlet.IPortletModule;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.portlet.PortletException;
import org.osivia.demo.customizer.plugin.DemoTemplateAdapter;
import org.osivia.demo.customizer.plugin.list.AccessoriesListTemplateModule;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;

public class DemoPlugin
extends AbstractPluginPortlet {
    private static final String PLUGIN_NAME = "demo.plugin";
    private static final String RECORD_LIST_SCHEMAS = "dublincore, common, toutatice, files, record";
    private IBundleFactory bundleFactory;

    public void init() throws PortletException {
        super.init();
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    protected String getPluginName() {
        return PLUGIN_NAME;
    }

    protected void customizeCMSProperties(CustomizationContext customizationContext) {
        this.customizeListTemplates(customizationContext);
        this.customizeMenuTemplates(customizationContext);
        this.customizeTemplateAdapters(customizationContext);
    }

    private void customizeListTemplates(CustomizationContext customizationContext) {
        Bundle bundle = this.bundleFactory.getBundle(customizationContext.getLocale());
        Map templates = this.getListTemplates(customizationContext);
        ListTemplate workspaceMemberRequests = (ListTemplate)templates.get("workspace-member-requests");
        if (workspaceMemberRequests != null) {
            ListTemplate workspaceMemberRequestsTiles = new ListTemplate("workspace-member-requests-tiles", bundle.getString("LIST_TEMPLATE_WORKSPACE_MEMBER_REQUESTS_TILES"), workspaceMemberRequests.getSchemas());
            workspaceMemberRequestsTiles.setModule(workspaceMemberRequests.getModule());
            templates.put(workspaceMemberRequestsTiles.getKey(), workspaceMemberRequestsTiles);
        }
        ListTemplate workspaceTiles = new ListTemplate("workspace-tiles", bundle.getString("LIST_TEMPLATE_WORKSPACE_TILES"), "dublincore, common, toutatice");
        templates.put(workspaceTiles.getKey(), workspaceTiles);
        ListTemplate accessoryList = new ListTemplate("accessories", bundle.getString("LIST_TEMPLATE_ACCESSORIES"), RECORD_LIST_SCHEMAS);
        accessoryList.setModule((IPortletModule)new AccessoriesListTemplateModule(this.getPortletContext()));
        templates.put(accessoryList.getKey(), accessoryList);
        ListTemplate newsList = new ListTemplate("news", bundle.getString("LIST_TEMPLATE_NEWS"), RECORD_LIST_SCHEMAS);
        templates.put(newsList.getKey(), newsList);
        ListTemplate documentsList = new ListTemplate("documents", bundle.getString("LIST_TEMPLATE_DOCUMENTS"), RECORD_LIST_SCHEMAS);
        templates.put(documentsList.getKey(), documentsList);
    }

    private void customizeMenuTemplates(CustomizationContext customizationContext) {
        Bundle bundle = this.bundleFactory.getBundle(customizationContext.getLocale());
        SortedMap templates = this.getMenuTemplates(customizationContext);
        templates.put("extranet", bundle.getString("MENU_TEMPLATE_EXTRANET"));
    }

    private void customizeTemplateAdapters(CustomizationContext customizationContext) {
        List adapters = this.getTemplateAdapters(customizationContext);
        DemoTemplateAdapter demo = new DemoTemplateAdapter();
        adapters.add(demo);
    }
}

