/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.demo.customizer.project;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Document;

public class GetProfileCommand
implements INuxeoCommand {
    private final String userName;

    public GetProfileCommand(String userName) {
        this.userName = userName;
    }

    public Object execute(Session session) throws Exception {
        Document userProfile = this.getUserProfile(session);
        return this.getFullDocument(session, userProfile);
    }

    private Document getUserProfile(Session session) throws Exception {
        OperationRequest request = session.newRequest("Services.GetToutaticeUserProfile");
        request.set("username", (Object)this.userName);
        return (Document)request.execute();
    }

    private Document getFullDocument(Session session, Document userProfile) throws Exception {
        OperationRequest request = session.newRequest("Document.Fetch");
        request.setHeader("X-NXDocumentProperties", "*");
        request.set("value", (Object)userProfile.getPath());
        return (Document)request.execute();
    }

    public String getId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("/");
        builder.append(this.userName);
        return builder.toString();
    }
}

