/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.demo.customizer.regions;

import java.util.Arrays;
import java.util.Map;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.customization.CustomizationModuleMetadatas;
import org.osivia.portal.api.customization.ICustomizationModule;
import org.osivia.portal.api.customization.ICustomizationModulesRepository;
import org.osivia.portal.api.theming.IRenderedRegions;

public class RegionsCustomizer
extends GenericPortlet
implements ICustomizationModule {
    private static final String CUSTOMIZER_NAME = "demo.customizer.regions";
    private static final String ATTRIBUTE_CUSTOMIZATION_MODULES_REPOSITORY = "CustomizationModulesRepository";
    private static final String CHARTE_CONTEXT_PATH = "/demo-charte";
    private static final String CHARTE_WEB_CONTEXT_PATH = "/demo-charte-web";
    private static final String CHARTE_EXTRANET_CONTEXT_PATH = "/demo-charte-extranet";
    private final CustomizationModuleMetadatas metadatas = this.generateMetadatas();
    private ICustomizationModulesRepository repository;

    private CustomizationModuleMetadatas generateMetadatas() {
        CustomizationModuleMetadatas metadatas = new CustomizationModuleMetadatas();
        metadatas.setName(CUSTOMIZER_NAME);
        metadatas.setModule((ICustomizationModule)this);
        metadatas.setCustomizationIDs(Arrays.asList("osivia.customizer.regions.id"));
        return metadatas;
    }

    public void init() throws PortletException {
        super.init();
        this.repository = (ICustomizationModulesRepository)this.getPortletContext().getAttribute(ATTRIBUTE_CUSTOMIZATION_MODULES_REPOSITORY);
        this.repository.register(this.metadatas);
    }

    public void destroy() {
        super.destroy();
        this.repository.unregister(this.metadatas);
    }

    public void customize(CustomizationContext customizationContext) {
        Map attributes = customizationContext.getAttributes();
        IRenderedRegions renderedRegion = (IRenderedRegions)attributes.get("osivia.customizer.regions.renderedRegions");
        String contextPath = (String)attributes.get("osivia.customizer.regions.themeContextPath");
        if (CHARTE_CONTEXT_PATH.equals(contextPath)) {
            renderedRegion.customizeRenderedRegion("toolbar", "/regions/toolbar.jsp");
            renderedRegion.customizeRenderedRegion("tabs", "/regions/tabs.jsp");
            renderedRegion.removeRenderedRegion("footer");
        } else if (CHARTE_WEB_CONTEXT_PATH.equals(contextPath)) {
            renderedRegion.customizeRenderedRegion("toolbar", "/regions/toolbar.jsp", CHARTE_CONTEXT_PATH);
            renderedRegion.removeRenderedRegion("drawer-toolbar");
            renderedRegion.customizeRenderedRegion("tabs", "/regions/tabs.jsp", CHARTE_CONTEXT_PATH);
            renderedRegion.removeRenderedRegion("footer");
        } else if (CHARTE_EXTRANET_CONTEXT_PATH.equals(contextPath)) {
            renderedRegion.customizeRenderedRegion("toolbar", "/regions/toolbar.jsp");
            renderedRegion.removeRenderedRegion("drawer-toolbar");
            renderedRegion.removeRenderedRegion("tabs");
            renderedRegion.removeRenderedRegion("footer");
        }
    }
}

