/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.demo.customizer.project;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.Portal;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.Window;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.demo.customizer.project.GetProfileCommand;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.customization.CustomizationModuleMetadatas;
import org.osivia.portal.api.customization.ICustomizationModule;
import org.osivia.portal.api.customization.ICustomizationModulesRepository;
import org.osivia.portal.api.customization.IProjectCustomizationConfiguration;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.portal.api.directory.v2.service.PersonService;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.urls.IPortalUrlFactory;

public class ProjectCustomizer
extends CMSPortlet
implements ICustomizationModule {
    private static final String CUSTOMIZER_NAME = "demo.customizer.project";
    private static final String ATTRIBUTE_CUSTOMIZATION_MODULES_REPOSITORY = "CustomizationModulesRepository";
    private static final String FIRST_CONNECTION_INDICATOR_PROPERTY = "first-connection";
    private static final String CGU_LEVEL_ATTRIBUTE = "osivia.services.cgu.level";
    private static final String CGU_PATH_ATTRIBUTE = "osivia.services.cgu.path";
    private static final String PLATFORM_INITIALIZED = "osivia.platform.initialized";
    private static final String INIT_INDICATOR_PROPERTY = "init-indicator";
    private final IPortalUrlFactory portalUrlFactory = (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");
    private final PersonService personService = (PersonService)DirServiceFactory.getService(PersonService.class);
    private final IBundleFactory bundleFactory;
    private final CustomizationModuleMetadatas metadatas;
    private ICustomizationModulesRepository repository;

    public ProjectCustomizer() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
        this.metadatas = new CustomizationModuleMetadatas();
        this.metadatas.setName(CUSTOMIZER_NAME);
        this.metadatas.setModule((ICustomizationModule)this);
        this.metadatas.setCustomizationIDs(Arrays.asList("osivia.project.customizer.id"));
    }

    public void init() throws PortletException {
        this.repository = (ICustomizationModulesRepository)this.getPortletContext().getAttribute(ATTRIBUTE_CUSTOMIZATION_MODULES_REPOSITORY);
        this.repository.register(this.metadatas);
    }

    public void destroy() {
        this.repository.unregister(this.metadatas);
    }

    public void customize(CustomizationContext customizationContext) {
        PortalControllerContext portalControllerContext = customizationContext.getPortalControllerContext();
        Map attributes = customizationContext.getAttributes();
        IProjectCustomizationConfiguration configuration = (IProjectCustomizationConfiguration)attributes.get("osivia.project.customizer.configuration");
        HttpServletRequest servletRequest = configuration.getHttpServletRequest();
        Principal principal = servletRequest.getUserPrincipal();
        Bundle bundle = this.bundleFactory.getBundle(customizationContext.getLocale());
        if (configuration.isBeforeInvocation()) {
            this.preparePlatformRedicrection(portalControllerContext, configuration, bundle);
            if (principal != null) {
                this.firstConnectionRedirection(portalControllerContext, configuration, principal, bundle);
                if (StringUtils.isNotEmpty((String)configuration.getCMSPath())) {
                    this.cguRedirection(portalControllerContext, configuration, principal, bundle);
                }
            }
        }
    }

    private void preparePlatformRedicrection(PortalControllerContext portalControllerContext, IProjectCustomizationConfiguration configuration, Bundle bundle) {
        Page page = configuration.getPage();
        if (page != null) {
            Portal portal = page.getPortal();
            PortalObject intranet = portal.getParent().getChild("default");
            String flag = intranet.getProperty(PLATFORM_INITIALIZED);
            Window window = (Window)page.getChild("virtual", Window.class);
            if (!(window != null && BooleanUtils.toBoolean((String)window.getDeclaredProperty(INIT_INDICATOR_PROPERTY)) || flag != null)) {
                String redirectionUrl;
                String intranetUrl = System.getProperty("demo.intranet.url");
                if (intranet != null && intranet instanceof Portal && intranetUrl != null) {
                    intranet.setDeclaredProperty("osivia.site.hostName", intranetUrl);
                    intranet.setDeclaredProperty(PLATFORM_INITIALIZED, "1");
                }
                PortalObject extranet = portal.getParent().getChild("extranet");
                String extranetUrl = System.getProperty("demo.extranet.url");
                if (extranet != null && extranet instanceof Portal && extranetUrl != null) {
                    extranet.setDeclaredProperty("osivia.site.hostName", extranetUrl);
                }
                HttpServletRequest servletRequest = configuration.getHttpServletRequest();
                HttpSession session = servletRequest.getSession();
                session.setAttribute("osivia.platform.init.pathToRedirect", (Object)configuration.buildRestorableURL());
                String displayName = bundle.getString("PLATFORM_INIT");
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("osivia.title", displayName);
                properties.put("osivia.ajaxLink", "1");
                properties.put("theme.dyna.partial_refresh_enabled", String.valueOf(true));
                properties.put(INIT_INDICATOR_PROPERTY, String.valueOf(true));
                try {
                    redirectionUrl = this.portalUrlFactory.getStartPortletInNewPage(portalControllerContext, "platform-init", displayName, "demo-initializer-instance", properties, null);
                }
                catch (PortalException e) {
                    throw new RuntimeException(e);
                }
                configuration.setRedirectionURL(redirectionUrl);
            }
        }
    }

    private void firstConnectionRedirection(PortalControllerContext portalControllerContext, IProjectCustomizationConfiguration configuration, Principal principal, Bundle bundle) {
        Page page;
        Window window;
        Person person = this.personService.getPerson(principal.getName());
        if (person != null && StringUtils.isBlank((String)person.getDisplayName()) && ((window = (page = configuration.getPage()) == null ? null : (Window)page.getChild("virtual", Window.class)) == null || !BooleanUtils.toBoolean((String)window.getDeclaredProperty(FIRST_CONNECTION_INDICATOR_PROPERTY)))) {
            String redirectionUrl;
            String displayName = bundle.getString("FIRST_CONNECTION_TITLE");
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("osivia.title", displayName);
            properties.put("osivia.ajaxLink", "1");
            properties.put("theme.dyna.partial_refresh_enabled", String.valueOf(true));
            properties.put(FIRST_CONNECTION_INDICATOR_PROPERTY, String.valueOf(true));
            properties.put("osivia.services.firstConnection.redirectionUrl", StringEscapeUtils.escapeHtml((String)configuration.buildRestorableURL()));
            try {
                redirectionUrl = this.portalUrlFactory.getStartPortletInNewPage(portalControllerContext, FIRST_CONNECTION_INDICATOR_PROPERTY, displayName, "osivia-services-first-connection-instance", properties, null);
            }
            catch (PortalException e) {
                throw new RuntimeException(e);
            }
            configuration.setRedirectionURL(redirectionUrl);
        }
    }

    private void cguRedirection(PortalControllerContext portalControllerContext, IProjectCustomizationConfiguration configuration, Principal principal, Bundle bundle) {
        Page page = configuration.getPage();
        if (page != null) {
            Window window = (Window)page.getChild("virtual", Window.class);
            HttpServletRequest servletRequest = configuration.getHttpServletRequest();
            HttpSession session = servletRequest.getSession();
            NuxeoController nuxeoController = new NuxeoController(this.getPortletContext());
            nuxeoController.setServletRequest(servletRequest);
            String path = page.getProperty(CGU_PATH_ATTRIBUTE);
            String portalLevel = page.getProperty(CGU_LEVEL_ATTRIBUTE);
            if (portalLevel == null || path == null) {
                return;
            }
            String checkedLevel = String.valueOf(session.getAttribute(CGU_LEVEL_ATTRIBUTE));
            if (StringUtils.equals((String)portalLevel, (String)checkedLevel)) {
                return;
            }
            if (window != null && StringUtils.isNotEmpty((String)window.getDeclaredProperty(CGU_PATH_ATTRIBUTE))) {
                return;
            }
            GetProfileCommand command = new GetProfileCommand(principal.getName());
            Document userProfile = (Document)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
            String userLevel = userProfile.getProperties().getString("ttc_userprofile:terms_of_use_agreement");
            session.setAttribute(CGU_LEVEL_ATTRIBUTE, (Object)userLevel);
            if (!portalLevel.equals(userLevel)) {
                String redirectionUrl;
                session.setAttribute("osivia.services.cgu.pathToRedirect", (Object)configuration.buildRestorableURL());
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put(CGU_PATH_ATTRIBUTE, path);
                properties.put(CGU_LEVEL_ATTRIBUTE, portalLevel);
                properties.put("osivia.title", bundle.getString("CGU_TITLE"));
                properties.put("osivia.hideTitle", "1");
                try {
                    redirectionUrl = this.portalUrlFactory.getStartPortletInNewPage(portalControllerContext, "cgu", bundle.getString("CGU_TITLE_MINI"), "osivia-services-cgu-portailPortletInstance", properties, null);
                }
                catch (PortalException e) {
                    throw new RuntimeException(e);
                }
                configuration.setRedirectionURL(redirectionUrl);
            }
        }
    }
}

