/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.demo.customizer.plugin.menubar;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cms.DocumentContext;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.menubar.MenubarContainer;
import org.osivia.portal.api.menubar.MenubarDropdown;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.menubar.MenubarModule;

public class DemoMenubarModule
implements MenubarModule {
    public void customizeSpace(PortalControllerContext portalControllerContext, List<MenubarItem> menubar, DocumentContext spaceDocumentContext) throws PortalException {
        String basePath = spaceDocumentContext == null ? null : spaceDocumentContext.getCmsPath();
        if (StringUtils.startsWith((String)basePath, (String)"/default-domain/UserWorkspaces/")) {
            Iterator<MenubarItem> iterator = menubar.iterator();
            while (iterator.hasNext()) {
                MenubarDropdown dropdown;
                MenubarItem item = iterator.next();
                MenubarContainer parent = item.getParent();
                if (parent == null || !(parent instanceof MenubarDropdown) || !StringUtils.equals((String)"CONFIGURATION", (String)(dropdown = (MenubarDropdown)parent).getId())) continue;
                iterator.remove();
            }
        }
    }

    public void customizeDocument(PortalControllerContext portalControllerContext, List<MenubarItem> menubar, DocumentContext documentContext) throws PortalException {
        String path = documentContext == null ? null : documentContext.getCmsPath();
        if (StringUtils.startsWith((String)path, (String)"/default-domain/UserWorkspaces/")) {
            NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
            DocumentType documentType = documentContext.getDocumentType();
            ArrayList<String> itemIdentifiers = new ArrayList<String>(Arrays.asList("WORKSPACE_ACL_MANAGEMENT", "SUBSCRIBE_URL"));
            ArrayList<String> dropdownIdentifiers = new ArrayList<String>();
            if (documentType != null && documentType.isRoot()) {
                itemIdentifiers.add("ADD");
            } else {
                if (!documentContext.getPermissions().isAnonymouslyReadable()) {
                    dropdownIdentifiers.add("SHARE");
                }
                if (StringUtils.equals((String)nuxeoController.getBasePath(), (String)StringUtils.substringBeforeLast((String)path, (String)"/"))) {
                    itemIdentifiers.add("DELETE");
                    itemIdentifiers.add("MOVE");
                }
            }
            Iterator<MenubarItem> iterator = menubar.iterator();
            while (iterator.hasNext()) {
                MenubarDropdown dropdown;
                MenubarItem item = iterator.next();
                MenubarContainer parent = item.getParent();
                if (itemIdentifiers.contains(item.getId())) {
                    iterator.remove();
                    continue;
                }
                if (parent == null || !(parent instanceof MenubarDropdown) || !dropdownIdentifiers.contains((dropdown = (MenubarDropdown)parent).getId())) continue;
                iterator.remove();
            }
        }
    }
}

