/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.demo.customizer.plugin;

import fr.toutatice.portail.cms.nuxeo.api.domain.AbstractPluginPortlet;
import fr.toutatice.portail.cms.nuxeo.api.domain.FragmentType;
import fr.toutatice.portail.cms.nuxeo.api.domain.ListTemplate;
import fr.toutatice.portail.cms.nuxeo.api.fragment.IFragmentModule;
import fr.toutatice.portail.cms.nuxeo.api.portlet.IPortletModule;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import org.osivia.demo.customizer.plugin.DemoTemplateAdapter;
import org.osivia.demo.customizer.plugin.cms.ExtranetNavigationAdapterModule;
import org.osivia.demo.customizer.plugin.fragment.LaunchSupportPortletModule;
import org.osivia.demo.customizer.plugin.fragment.ProduitRecordFragmentModule;
import org.osivia.demo.customizer.plugin.list.AccessoriesListTemplateModule;
import org.osivia.demo.customizer.plugin.menubar.DemoMenubarModule;
import org.osivia.demo.customizer.plugin.player.RecordPlayer;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;

public class DemoPlugin
extends AbstractPluginPortlet {
    private static final String PLUGIN_NAME = "demo.plugin";
    private static final String RECORD_LIST_SCHEMAS = "dublincore, common, toutatice, files, record";
    private IBundleFactory bundleFactory;

    public void init() throws PortletException {
        super.init();
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    protected String getPluginName() {
        return PLUGIN_NAME;
    }

    protected void customizeCMSProperties(CustomizationContext customizationContext) {
        this.customizePlayers(customizationContext);
        this.customizeListTemplates(customizationContext);
        this.customizeMenuTemplates(customizationContext);
        this.customizeTemplateAdapters(customizationContext);
        this.customizeMenubarModules(customizationContext);
        this.customizeFragments(customizationContext);
        this.customizeNavigationAdapters(customizationContext);
    }

    private void customizePlayers(CustomizationContext customizationContext) {
        List players = this.getPlayers(customizationContext);
        RecordPlayer record = new RecordPlayer();
        players.add(0, record);
    }

    private void customizeListTemplates(CustomizationContext customizationContext) {
        Bundle bundle = this.bundleFactory.getBundle(customizationContext.getLocale());
        Map templates = this.getListTemplates(customizationContext);
        ListTemplate workspaceMemberRequests = (ListTemplate)templates.get("workspace-member-requests");
        if (workspaceMemberRequests != null) {
            ListTemplate workspaceMemberRequestsTiles = new ListTemplate("workspace-member-requests-tiles", bundle.getString("LIST_TEMPLATE_WORKSPACE_MEMBER_REQUESTS_TILES"), workspaceMemberRequests.getSchemas());
            workspaceMemberRequestsTiles.setModule(workspaceMemberRequests.getModule());
            templates.put(workspaceMemberRequestsTiles.getKey(), workspaceMemberRequestsTiles);
        }
        ListTemplate workspaceTiles = new ListTemplate("workspace-tiles", bundle.getString("LIST_TEMPLATE_WORKSPACE_TILES"), "dublincore, common, toutatice");
        templates.put(workspaceTiles.getKey(), workspaceTiles);
        ListTemplate accessoryList = new ListTemplate("accessories", bundle.getString("LIST_TEMPLATE_ACCESSORIES"), RECORD_LIST_SCHEMAS);
        accessoryList.setModule((IPortletModule)new AccessoriesListTemplateModule(this.getPortletContext()));
        templates.put(accessoryList.getKey(), accessoryList);
        ListTemplate newsList = new ListTemplate("news", bundle.getString("LIST_TEMPLATE_NEWS"), RECORD_LIST_SCHEMAS);
        templates.put(newsList.getKey(), newsList);
        ListTemplate documentsList = new ListTemplate("documents", bundle.getString("LIST_TEMPLATE_DOCUMENTS"), RECORD_LIST_SCHEMAS);
        templates.put(documentsList.getKey(), documentsList);
    }

    private void customizeMenuTemplates(CustomizationContext customizationContext) {
        Bundle bundle = this.bundleFactory.getBundle(customizationContext.getLocale());
        SortedMap templates = this.getMenuTemplates(customizationContext);
        templates.put("extranet", bundle.getString("MENU_TEMPLATE_EXTRANET"));
    }

    private void customizeTemplateAdapters(CustomizationContext customizationContext) {
        List adapters = this.getTemplateAdapters(customizationContext);
        DemoTemplateAdapter demo = new DemoTemplateAdapter();
        adapters.add(demo);
    }

    private void customizeMenubarModules(CustomizationContext customizationContext) {
        List modules = this.getMenubarModules(customizationContext);
        DemoMenubarModule module = new DemoMenubarModule();
        modules.add(module);
    }

    private void customizeFragments(CustomizationContext customizationContext) {
        List fragmentTypes = this.getFragmentTypes(customizationContext);
        Bundle bundle = this.bundleFactory.getBundle(customizationContext.getLocale());
        ProduitRecordFragmentModule RecordPropertyModule = new ProduitRecordFragmentModule(this.getPortletContext());
        FragmentType recordPropertyFragment = new FragmentType("record_property", bundle.getString("FRAGMENT_PRODUCT_RECORD"), (IFragmentModule)RecordPropertyModule);
        fragmentTypes.add(recordPropertyFragment);
        LaunchSupportPortletModule launchSupportPortletModule = new LaunchSupportPortletModule(this.getPortletContext());
        FragmentType launchSupportFragment = new FragmentType("launch_support", bundle.getString("FRAGMENT_LAUNCH_SUPPORT"), (IFragmentModule)launchSupportPortletModule);
        fragmentTypes.add(launchSupportFragment);
    }

    private void customizeNavigationAdapters(CustomizationContext customizationContext) {
        PortletContext portletContext = this.getPortletContext();
        List navigationAdapters = this.getNavigationAdapters(customizationContext);
        ExtranetNavigationAdapterModule extranet = new ExtranetNavigationAdapterModule(portletContext);
        navigationAdapters.add(extranet);
    }
}

