/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.demo.customizer.plugin.cms;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.domain.INavigationAdapterModule;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletContext;
import org.apache.commons.lang.StringUtils;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.Portal;
import org.jboss.portal.core.model.portal.PortalObject;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.demo.customizer.plugin.cms.GetRecordsCommand;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.cms.EcmDocument;
import org.osivia.portal.api.cms.IVirtualNavigationService;
import org.osivia.portal.api.cms.Symlink;
import org.osivia.portal.api.cms.Symlinks;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.context.ControllerContextAdapter;
import org.osivia.portal.core.portalobjects.PortalObjectUtils;

public class ExtranetNavigationAdapterModule
implements INavigationAdapterModule {
    private final IVirtualNavigationService virtualNavigationService;
    private PortletContext portletContext;

    public ExtranetNavigationAdapterModule(PortletContext portletContext) {
        this.portletContext = portletContext;
        this.virtualNavigationService = (IVirtualNavigationService)Locator.findMBean(IVirtualNavigationService.class, (String)"osivia:service=VirtualNavigationService");
    }

    public String adaptNavigationPath(PortalControllerContext portalControllerContext, EcmDocument document) throws CMSException {
        return null;
    }

    public Symlinks getSymlinks(PortalControllerContext portalControllerContext) throws CMSException {
        Page defaultPage;
        String basePath;
        Symlinks symlinks = null;
        ControllerContext controllerContext = ControllerContextAdapter.getControllerContext((PortalControllerContext)portalControllerContext);
        Portal portal = PortalObjectUtils.getPortal((ControllerContext)controllerContext);
        if (PortalObjectUtils.isSpaceSite((PortalObject)portal) && StringUtils.isNotEmpty((String)(basePath = (defaultPage = portal.getDefaultPage()).getDeclaredProperty("osivia.cms.basePath")))) {
            GetRecordsCommand command;
            symlinks = new Symlinks();
            NuxeoController nuxeoController = this.getNuxeoController();
            Documents documents = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)(command = new GetRecordsCommand()));
            if (!documents.isEmpty()) {
                ArrayList<Symlink> links = new ArrayList<Symlink>(documents.size());
                symlinks.setLinks(links);
                String productsPath = nuxeoController.getDocumentContext("page_produits").getCmsPath();
                HashMap<String, Symlink> products = new HashMap<String, Symlink>();
                ArrayList<Document> productLinkedRecords = new ArrayList<Document>();
                for (Document document : documents) {
                    if ("RecordFolder".equals(document.getType())) {
                        symlinks.getPaths().add(document.getPath());
                        continue;
                    }
                    if (!"Record".equals(document.getType())) continue;
                    if ("record_news".equals(document.getString("rcd:procedureModelWebId")) || "record_documents".equals(document.getString("rcd:procedureModelWebId"))) {
                        productLinkedRecords.add(document);
                        continue;
                    }
                    boolean product = "record_produits".equals(document.getString("rcd:procedureModelWebId"));
                    String parentPath = product ? productsPath : basePath;
                    String segment = this.generateSegmentFromTitle(document.getTitle());
                    String targetPath = document.getPath();
                    String targetWebId = document.getString("ttc:webid");
                    Symlink symlink = this.virtualNavigationService.createSymlink(parentPath, segment, targetPath, targetWebId);
                    links.add(symlink);
                    if (!product) continue;
                    products.put(document.getPath(), symlink);
                }
                for (Document document : productLinkedRecords) {
                    PropertyMap data = document.getProperties().getMap("rcd:data");
                    PropertyMap product = data.getMap("produit");
                    Symlink productSymlink = (Symlink)products.get(product.getString("ecm:path"));
                    if (productSymlink == null) continue;
                    String segment = this.generateSegmentFromTitle(document.getTitle());
                    String targetPath = document.getPath();
                    String targetWebId = document.getString("ttc:webid");
                    Symlink symlink = this.virtualNavigationService.createSymlink(productSymlink, segment, targetPath, targetWebId);
                    links.add(symlink);
                }
            }
        }
        return symlinks;
    }

    private String generateSegmentFromTitle(String title) {
        String name = title;
        name = StringUtils.lowerCase((String)name);
        name = Normalizer.normalize(name, Normalizer.Form.NFD);
        name = name.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "");
        name = name.replaceAll("[^a-z0-9]", "-");
        while (StringUtils.startsWith((String)name, (String)"-")) {
            name = StringUtils.removeStart((String)name, (String)"-");
        }
        while (StringUtils.endsWith((String)name, (String)"-")) {
            name = StringUtils.removeEnd((String)name, (String)"-");
        }
        while (StringUtils.contains((String)name, (String)"--")) {
            name = StringUtils.replace((String)name, (String)"--", (String)"-");
        }
        return name;
    }

    public void adaptNavigationItem(PortalControllerContext portalControllerContext, CMSItem navigationItem) throws CMSException {
        ControllerContext controllerContext = ControllerContextAdapter.getControllerContext((PortalControllerContext)portalControllerContext);
        Portal portal = PortalObjectUtils.getPortal((ControllerContext)controllerContext);
        if (PortalObjectUtils.isSpaceSite((PortalObject)portal)) {
            String modelWebId;
            Map properties = navigationItem.getProperties();
            Document document = (Document)navigationItem.getNativeItem();
            if ("RecordFolder".equals(document.getType())) {
                properties.remove("menuItem");
            } else if ("Record".equals(document.getType()) && "record_produits".equals(modelWebId = document.getString("rcd:procedureModelWebId"))) {
                properties.put("menuItem", "1");
                properties.put("navigationElement", "1");
                properties.put("pageDisplayMode", "1");
                properties.put("pageTemplate", "/default/templates/record-produit");
            }
        }
    }

    private NuxeoController getNuxeoController() {
        NuxeoController nuxeoController = new NuxeoController(this.portletContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
        return nuxeoController;
    }
}

