/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.demo.customizer.plugin.fragment;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.fragment.FragmentModule;
import java.io.IOException;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.demo.customizer.plugin.DemoUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;

public class LaunchSupportPortletModule
extends FragmentModule {
    public static final String ID = "launch_support";
    private static final String NUXEO_PATH_WINDOW_PROPERTY = "osivia.cms.uri";
    private static final String LAUNCH_PROCEDURE_PROPERTY = "osivia.launch.procedure.webid";
    private static final String JSP_NAME = "launch-support";

    public LaunchSupportPortletModule(PortletContext portletContext) {
        super(portletContext);
    }

    protected void doView(RenderRequest request, RenderResponse response, PortletContext portletContext) throws PortletException, IOException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String nuxeoPath = window.getProperty(NUXEO_PATH_WINDOW_PROPERTY);
        String procedureWebid = window.getProperty(LAUNCH_PROCEDURE_PROPERTY);
        if (StringUtils.isNotEmpty((String)nuxeoPath) && StringUtils.isNotBlank((String)procedureWebid)) {
            NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
            nuxeoPath = nuxeoController.getComputedPath(nuxeoPath);
            NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(nuxeoPath);
            Document document = documentContext.getDenormalizedDocument();
            nuxeoController.setCurrentDoc(document);
            PropertyMap properties = document.getProperties();
            String producteWebId = properties.getString("ttc:webid");
            String launchSupportUrl = this.getLaunchSupportUrl(procedureWebid, nuxeoController, document, producteWebId);
            request.setAttribute("launchSupportUrl", (Object)launchSupportUrl);
        }
    }

    private String getLaunchSupportUrl(String procedureWebid, NuxeoController nuxeoController, Document document, String producteWebId) {
        JSONObject variables = new JSONObject();
        variables.put((Object)"productWebid", (Object)producteWebId);
        variables.put((Object)"produit", (Object)document.getTitle());
        return DemoUtils.getLaunchProcedureUrl((NuxeoController)nuxeoController, (JSONObject)variables, (String)procedureWebid);
    }

    public void doAdmin(PortalControllerContext portalControllerContext) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String nuxeoPath = window.getProperty(NUXEO_PATH_WINDOW_PROPERTY);
        request.setAttribute("nuxeoPath", (Object)nuxeoPath);
        String procedureWebid = window.getProperty(LAUNCH_PROCEDURE_PROPERTY);
        request.setAttribute("procedureWebid", (Object)procedureWebid);
    }

    public void processAction(PortalControllerContext portalControllerContext) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        if ("admin".equals(request.getPortletMode().toString()) && "save".equals(request.getParameter("javax.portlet.action"))) {
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            window.setProperty(NUXEO_PATH_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("nuxeoPath")));
            window.setProperty(LAUNCH_PROCEDURE_PROPERTY, StringUtils.trimToNull((String)request.getParameter("procedureWebid")));
        }
    }

    public String getViewJSPName() {
        return JSP_NAME;
    }

    public String getAdminJSPName() {
        return JSP_NAME;
    }

    public boolean isDisplayedInAdmin() {
        return true;
    }
}

