/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class HashMapTest {
    public static void main(String[] args) throws Exception {
        int i;
        int num = 10000;
        for (int i2 = 0; i2 < args.length; ++i2) {
            if (!args[i2].equals("-num")) {
                System.out.println("HashMapTest [-num <num>] [-help]");
                return;
            }
            num = Integer.parseInt(args[++i2]);
        }
        HashMapTest t = new HashMapTest();
        Class[] classes = new Class[]{HashMap.class, TreeMap.class, ConcurrentReaderHashMap.class, ConcurrentHashMap.class};
        Map[] maps = new Map[classes.length];
        System.out.println("\nTesting creation times");
        for (i = 0; i < classes.length; ++i) {
            t.testCreation(classes[i], num);
        }
        for (i = 0; i < classes.length; ++i) {
            maps[i] = (Map)classes[i].newInstance();
        }
        System.out.println("\nTesting puts and gets");
        for (i = 0; i < maps.length; ++i) {
            t.testPutAndGet(maps[i], num);
        }
    }

    private void testCreation(Class cl, int num) throws IllegalAccessException, InstantiationException {
        long start = System.currentTimeMillis();
        for (int i = 0; i < num; ++i) {
            cl.newInstance();
        }
        long stop = System.currentTimeMillis();
        System.out.println("Took " + (stop - start) + "ms to create " + num + " instances of " + cl.getName());
    }

    private void testPutAndGet(Map m, int num) throws Exception {
        int i;
        long start = System.currentTimeMillis();
        for (i = 0; i < num; ++i) {
            m.put(new Long(i), "bla");
        }
        long stop = System.currentTimeMillis();
        System.out.println("Took " + (stop - start) + "ms to insert " + m.size() + " elements into " + m.getClass().getName());
        start = System.currentTimeMillis();
        for (i = 0; i < num; ++i) {
            Object retval = m.get(new Long(i));
            if (retval != null) continue;
            throw new Exception("retval for " + i + " is null");
        }
        stop = System.currentTimeMillis();
        System.out.println("Took " + (stop - start) + "ms to fetch " + m.size() + " elements from " + m.getClass().getName());
        start = System.currentTimeMillis();
        m.clear();
        stop = System.currentTimeMillis();
        System.out.println("Took " + (stop - start) + "ms to clear " + m.getClass().getName() + "\n");
    }
}

