/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.impl.jsr168;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.portal.common.util.AbstractTypedMap;
import org.jboss.portal.common.util.TypedMap;
import org.jboss.portal.portlet.impl.jsr168.PortletParameter;
import org.jboss.portal.portlet.info.NavigationInfo;
import org.jboss.portal.portlet.info.ParameterInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletParameterMap {
    private static final String[] EMPTY_STRINGS = new String[0];
    private NavigationInfo navigationInfo;
    private Map<String, PortletParameter> entries;
    private Set<String> publicEntryRemovals;
    private TypedMap<String, String[], String, PortletParameter> combinedMap;
    private static AbstractTypedMap.Converter<String, String> keyConverter = new AbstractTypedMap.Converter<String, String>(){

        protected String getInternal(String external) throws IllegalArgumentException, ClassCastException {
            return external;
        }

        protected String getExternal(String internal) {
            return internal;
        }

        protected boolean equals(String left, String right) {
            return left.equals(right);
        }
    };
    private static AbstractTypedMap.Converter<String[], PortletParameter> valueConverter = new AbstractTypedMap.Converter<String[], PortletParameter>(){

        protected PortletParameter getInternal(String[] external) throws IllegalArgumentException, ClassCastException {
            throw new UnsupportedOperationException("Cannot write");
        }

        protected String[] getExternal(PortletParameter internal) {
            return (String[])internal.getValues().clone();
        }

        protected boolean equals(PortletParameter left, PortletParameter right) {
            throw new UnsupportedOperationException();
        }
    };

    public PortletParameterMap(NavigationInfo navigationInfo) {
        this.navigationInfo = navigationInfo;
        this.entries = new HashMap<String, PortletParameter>();
        this.publicEntryRemovals = new HashSet<String>();
        this.combinedMap = new TypedMap(this.entries, keyConverter, valueConverter);
    }

    public PortletParameterMap(PortletParameterMap original) {
        this.navigationInfo = original.navigationInfo;
        this.entries = new HashMap<String, PortletParameter>(original.entries);
        this.publicEntryRemovals = new HashSet<String>(original.publicEntryRemovals);
        this.combinedMap = new TypedMap(this.entries, keyConverter, valueConverter);
    }

    public String getParameterValue(String name) {
        String[] values = this.getParameterValues(name);
        return values != null && values.length > 0 ? values[0] : null;
    }

    public String[] getParameterValues(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        PortletParameter entry = this.entries.get(name);
        return entry != null ? entry.getValues() : null;
    }

    public void setParameterValue(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (value == null) {
            throw new IllegalArgumentException("No null string array accepted");
        }
        this.internalPut(name, new String[]{value}, false);
    }

    public void setParameterValues(String name, String[] value) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (value == null) {
            throw new IllegalArgumentException("No null string array accepted");
        }
        if (value.length == 0) {
            throw new IllegalArgumentException("Render parameter value cannot be a zero length array");
        }
        for (int i = 0; i < value.length; ++i) {
            if (value[i] != null) continue;
            throw new IllegalArgumentException("String of parameter value at index " + i + " must not be null");
        }
        this.internalPut(name, value, true);
    }

    private void internalPut(String name, String[] value, boolean cloneValue) {
        PortletParameter entry;
        if (cloneValue) {
            value = (String[])value.clone();
        }
        if ((entry = this.entries.get(name)) == null) {
            PortletParameter.Scope scope;
            ParameterInfo parameterInfo = this.navigationInfo.getPublicParameter(name);
            PortletParameter.Scope scope2 = scope = parameterInfo == null ? PortletParameter.Scope.PRIVATE : PortletParameter.Scope.PUBLIC;
            if (scope == PortletParameter.Scope.PUBLIC) {
                this.publicEntryRemovals.remove(name);
            }
            this.entries.put(name, new PortletParameter(scope, value));
        } else {
            this.entries.put(name, new PortletParameter(entry.getScope(), value));
        }
    }

    public void removePublicParameterValue(String name) {
        ParameterInfo parameterInfo = this.navigationInfo.getPublicParameter(name);
        if (parameterInfo != null) {
            this.publicEntryRemovals.add(name);
            this.entries.remove(name);
        }
    }

    public Map<String, String[]> getMap() {
        return this.combinedMap;
    }

    public void setMap(Map<String, String[]> map) {
        if (map == null) {
            throw new IllegalArgumentException("No null map accepted");
        }
        for (Map.Entry<String, String[]> entry : map.entrySet()) {
            String[] values;
            if (!(entry.getKey() instanceof String)) {
                throw new IllegalArgumentException();
            }
            if (!(entry.getValue() instanceof String[])) {
                throw new IllegalArgumentException();
            }
            for (String value : values = entry.getValue()) {
                if (value != null) continue;
                throw new IllegalArgumentException();
            }
        }
        this.entries.clear();
        for (Map.Entry<String, String[]> entry : map.entrySet()) {
            this.internalPut(entry.getKey(), entry.getValue(), true);
        }
    }

    public Map<String, String[]> getPrivateMapSnapshot() {
        return this.getMapSnapshot(PortletParameter.Scope.PRIVATE);
    }

    public Map<String, String[]> getPublicMapSnapshot() {
        Map<String, String[]> snapshot = this.getMapSnapshot(PortletParameter.Scope.PUBLIC);
        for (String removal : this.publicEntryRemovals) {
            snapshot.put(removal, EMPTY_STRINGS);
        }
        return snapshot;
    }

    private Map<String, String[]> getMapSnapshot(PortletParameter.Scope scope) {
        HashMap<String, String[]> snapshot = new HashMap<String, String[]>();
        for (Map.Entry<String, PortletParameter> entry : this.entries.entrySet()) {
            PortletParameter parameter = entry.getValue();
            if (parameter.getScope() != scope) continue;
            snapshot.put(entry.getKey(), (String[])parameter.getValues().clone());
        }
        return snapshot;
    }
}

