/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.admin.ui.coordination;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jboss.portal.core.admin.ui.coordination.CoordinationManagerBean;
import org.jboss.portal.core.admin.ui.coordination.QNameSelectItem;
import org.jboss.portal.core.controller.coordination.AliasBindingInfo;
import org.jboss.portal.core.controller.coordination.IllegalCoordinationException;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.portlet.info.NavigationInfo;
import org.jboss.portal.portlet.info.ParameterInfo;
import org.jboss.portal.portlet.info.PortletInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AliasBindingManagerBean
extends CoordinationManagerBean.CoordinationBean {
    private Map<String, DisplayAliasBinding> displayAliasBindings;
    private Set<QNameSelectItem> availableRenderParameters;
    private String aliasName;
    private List<String> originalQNames;

    public AliasBindingManagerBean() {
    }

    public AliasBindingManagerBean(CoordinationManagerBean managerBean) {
        super(managerBean);
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public void setAliasName(String aliasName) {
        this.aliasName = aliasName;
    }

    public List<String> getOriginalQNames() {
        return this.originalQNames;
    }

    public void setOriginalQNames(List<String> originalQNames) {
        this.originalQNames = originalQNames;
    }

    @Override
    public boolean loadInfoFrom(Page page) {
        Collection bindings = this.managerBean.getCoordinationService().getAliasBindings(page);
        if (!bindings.isEmpty()) {
            this.displayAliasBindings = new HashMap<String, DisplayAliasBinding>();
            for (AliasBindingInfo binding : bindings) {
                this.displayAliasBindings.put(binding.getName(), new DisplayAliasBinding(binding));
            }
            return true;
        }
        this.displayAliasBindings = Collections.emptyMap();
        return false;
    }

    public List<DisplayAliasBinding> getDisplayAliasBindings() {
        if (this.displayAliasBindings == null || this.displayAliasBindings.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<DisplayAliasBinding> result = new LinkedList<DisplayAliasBinding>(this.displayAliasBindings.values());
        Collections.sort(result);
        return result;
    }

    public List<QNameSelectItem> getAvailableRenderParameters() {
        if (this.availableRenderParameters == null) {
            return Collections.emptyList();
        }
        LinkedList<QNameSelectItem> result = new LinkedList<QNameSelectItem>(this.availableRenderParameters);
        Collections.sort(result);
        return result;
    }

    @Override
    protected void internalRename(String oldName, String newName) throws IllegalCoordinationException {
        this.managerBean.getCoordinationService().renameAliasBinding(this.managerBean.getSelectedPage(), oldName, newName);
    }

    @Override
    protected void internalCreate() throws IllegalCoordinationException {
        if (this.aliasName != null) {
            HashSet<QName> qNames = new HashSet<QName>();
            for (String qName : this.originalQNames) {
                qNames.add(QName.valueOf(qName));
            }
            this.managerBean.getCoordinationService().setAliasBinding(this.managerBean.getSelectedPage(), this.aliasName, qNames);
        }
    }

    @Override
    protected String getBeanName() {
        return this.aliasName;
    }

    @Override
    public String resetSelection() {
        this.aliasName = null;
        this.originalQNames = null;
        return super.resetSelection();
    }

    @Override
    public String delete(String name) throws IllegalCoordinationException {
        this.managerBean.getCoordinationService().removeAliasBinding(this.managerBean.getSelectedPage(), name);
        return this.resetSelection();
    }

    @Override
    public void extractInfoFrom(Window window, PortletInfo info) {
        NavigationInfo navInfo = info.getNavigation();
        for (ParameterInfo pInfo : navInfo.getPublicParameters()) {
            this.availableRenderParameters.add(new QNameSelectItem(pInfo.getName()));
        }
    }

    @Override
    public void initKnowing(Collection<PortalObject> children) {
        this.availableRenderParameters = new HashSet<QNameSelectItem>();
    }

    @Override
    public String getObjectTypeName() {
        return "COORDINATION_ALIAS";
    }

    @Override
    public String getObjectNameForMessages() {
        return "alias";
    }

    public boolean isAlreadyExisting(String objectName) {
        return this.displayAliasBindings.containsKey(objectName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DisplayAliasBinding
    implements Comparable {
        private AliasBindingInfo alias;
        private List<QName> names;

        public DisplayAliasBinding(AliasBindingInfo binding) {
            this.alias = binding;
            this.names = new ArrayList<QName>(binding.getParameterNames());
        }

        public List<QName> getNames() {
            return this.names;
        }

        public String getName() {
            return this.alias.getName();
        }

        public AliasBindingInfo getAlias() {
            return this.alias;
        }

        public int compareTo(Object o) {
            DisplayAliasBinding other = (DisplayAliasBinding)o;
            return this.getName().compareTo(other.getName());
        }
    }
}

