/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.ConfigureException;
import org.jboss.cache.eviction.EvictionConfiguration;
import org.jboss.cache.xml.XmlHelper;
import org.w3c.dom.Element;

public class MRUConfiguration
implements EvictionConfiguration {
    private static final Log log = LogFactory.getLog((Class)MRUConfiguration.class);
    private int maxNodes;

    public int getMaxNodes() {
        return this.maxNodes;
    }

    public void setMaxNodes(int maxNodes) {
        this.maxNodes = maxNodes;
    }

    public void parseXMLConfig(Element element) throws ConfigureException {
        String name = element.getAttribute("name");
        if (name == null || name.equals("")) {
            throw new ConfigureException("Name is required for the eviction region");
        }
        String maxNodes = XmlHelper.getAttr(element, "maxNodes", "attribute", "name");
        if (maxNodes == null || maxNodes.equals("")) {
            throw new ConfigureException("Cannot have 0 for maxNodes on a MRUAlgorithm");
        }
        this.setMaxNodes(Integer.parseInt(maxNodes));
        if (log.isDebugEnabled()) {
            log.debug((Object)("parseConfig: name -- " + name + " maxNodes -- " + this.getMaxNodes()));
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("MRUConfiguration: ").append(" maxNodes =").append(this.getMaxNodes());
        return str.toString();
    }
}

