/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.identity.services.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jboss.portal.common.io.IOTools;
import org.jboss.portal.core.identity.services.metadata.CoreIdentityConfigurationException;
import org.jboss.portal.core.identity.services.metadata.IdentityUIConfiguration;
import org.jboss.portal.core.identity.services.metadata.IdentityUIConfigurationService;
import org.jboss.portal.core.identity.services.metadata.UIComponentConfiguration;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.IdentityServiceController;
import org.jboss.portal.identity.UserProfileModule;
import org.jboss.portal.identity.info.PropertyInfo;
import org.jboss.portal.jems.as.JNDI;
import org.jboss.portal.jems.as.system.AbstractJBossService;
import org.jboss.portal.workflow.service.WorkflowService;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TermBeforeSetParentCallback;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.UnmarshallingContext;
import org.jboss.xb.binding.sunday.unmarshalling.XsdBinder;
import org.jbpm.JbpmContext;
import org.jbpm.graph.def.ProcessDefinition;

public class IdentityUIConfigurationServiceImpl
extends AbstractJBossService
implements IdentityUIConfigurationService {
    private static final String xmlLocation = "conf/identity-ui-configuration.xml";
    private static final String schemaLocation = "conf/schema/identity-ui-configuration.xsd";
    private IdentityUIConfiguration configuration;
    private WorkflowService workflowService;
    private IdentityServiceController identityServiceController;
    private UserProfileModule userProfileModule;
    private JNDI.Binding jndiBinding;
    private String jndiName = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startWorkflow() throws Exception {
        try {
            if (this.configuration.enableWorkflow()) {
                this.isValidConfiguration();
                String subscriptionMode = this.configuration.getSubscriptionMode();
                String adminSubscriptionMode = this.configuration.getAdminSubscriptionMode();
                String emailValidationProcess = "jbp_identity_validate_email";
                if (subscriptionMode == null || adminSubscriptionMode == null || emailValidationProcess == null) throw new CoreIdentityConfigurationException("processName must not be null.");
                this.createJBPMContext(emailValidationProcess);
                this.createJBPMContext(subscriptionMode);
                this.createJBPMContext(adminSubscriptionMode);
                this.log.info((Object)"jBPM workflow started ...");
                return;
            } else {
                this.log.info((Object)"not starting jBPM workflow ...");
            }
            return;
        }
        catch (Exception e) {
            this.log.error((Object)"Error while starting core identity services ...");
            super.stopService();
            throw new CoreIdentityConfigurationException(e);
        }
    }

    public void stopWorkflow() {
    }

    public void startService() throws Exception {
        super.startService();
        this.configuration = this.createConfiguration();
        if (this.jndiName != null) {
            this.jndiBinding = new JNDI.Binding(this.jndiName, (Object)this);
            this.jndiBinding.bind();
        }
        this.startWorkflow();
    }

    public void stopService() throws Exception {
        super.stopService();
        if (this.jndiBinding != null) {
            this.jndiBinding.unbind();
            this.jndiBinding = null;
        }
        this.stopWorkflow();
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public void setJNDIName(String jndiName) {
        this.jndiName = jndiName;
    }

    public IdentityUIConfiguration getConfiguration() {
        return this.configuration;
    }

    public IdentityServiceController getIdentityServiceController() {
        return this.identityServiceController;
    }

    public void setIdentityServiceController(IdentityServiceController identityServiceController) {
        this.identityServiceController = identityServiceController;
    }

    public UserProfileModule getUserProfileModule() {
        if (this.userProfileModule == null) {
            try {
                this.userProfileModule = (UserProfileModule)this.identityServiceController.getIdentityContext().getObject("UserProfile");
            }
            catch (IdentityException e) {
                this.log.error((Object)"failed to load UserProfileModule", (Throwable)e);
            }
        }
        return this.userProfileModule;
    }

    public void setUserProfileModule(UserProfileModule userProfileModule) {
        this.userProfileModule = userProfileModule;
    }

    public WorkflowService getWorkflowService() throws CoreIdentityConfigurationException {
        if (this.workflowService == null) {
            throw new CoreIdentityConfigurationException("Workflow service not found. Make sure that the workflow service is deploy.");
        }
        return this.workflowService;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    private void createJBPMContext(String processName) throws CoreIdentityConfigurationException {
        if (!"automatic".equals(processName)) {
            JbpmContext jbpmContext;
            block6: {
                String fileName = "conf/processes/" + processName + ".xml";
                jbpmContext = null;
                try {
                    jbpmContext = this.getWorkflowService().getJbpmConfiguration().createJbpmContext();
                    ProcessDefinition processDefinition = jbpmContext.getGraphSession().findLatestProcessDefinition(processName);
                    if (processDefinition == null) {
                        processDefinition = ProcessDefinition.parseXmlResource((String)fileName);
                        jbpmContext.deployProcessDefinition(processDefinition);
                        this.log.debug((Object)("deloying process definition: " + processName));
                        break block6;
                    }
                    if (!this.configuration.isOverwriteWorkflow()) break block6;
                    ProcessDefinition fromConfig = ProcessDefinition.parseXmlResource((String)fileName);
                    jbpmContext.deployProcessDefinition(fromConfig);
                    this.log.debug((Object)("overwriting process definition: " + processName));
                }
                catch (Exception e) {
                    try {
                        throw new CoreIdentityConfigurationException("Invalid subscription mode [" + processName + "] ! Please make sure that the file and the process name match - also check the syntax.", e);
                    }
                    catch (Throwable throwable) {
                        IOTools.safeClose(jbpmContext);
                        throw throwable;
                    }
                }
            }
            IOTools.safeClose((Object)jbpmContext);
        }
    }

    private IdentityUIConfiguration createConfiguration() throws CoreIdentityConfigurationException {
        try {
            SchemaBinding schema = XsdBinder.bind((String)this.getURL(schemaLocation).toString());
            schema.setIgnoreUnresolvedFieldOrClass(false);
            TermBeforeSetParentCallback componentCallback = new TermBeforeSetParentCallback(){

                public Object beforeSetParent(Object o, UnmarshallingContext ctx) {
                    UIComponentConfiguration uiComponent = null;
                    ElementBinding eb = (ElementBinding)ctx.getParticle().getTerm();
                    String localPart = eb.getQName().getLocalPart();
                    if ("ui-component".equals(localPart)) {
                        uiComponent = (UIComponentConfiguration)o;
                        try {
                            PropertyInfo propertyInfo = IdentityUIConfigurationServiceImpl.this.getUserProfileModule().getProfileInfo().getPropertyInfo(uiComponent.getPropertyRef());
                            uiComponent.setPropertyInfo(propertyInfo);
                        }
                        catch (IdentityException e) {
                            throw new IllegalArgumentException("cannot resolve property: " + uiComponent.getPropertyRef(), e);
                        }
                    }
                    return uiComponent;
                }
            };
            TypeBinding cb = schema.getType(new QName("UIComponent"));
            cb.setBeforeSetParentCallback(componentCallback);
            TermBeforeSetParentCallback valueCallback = new TermBeforeSetParentCallback(){

                public Object beforeSetParent(Object o, UnmarshallingContext ctx) {
                    ElementBinding eb = (ElementBinding)ctx.getParticle().getTerm();
                    String localPart = eb.getQName().getLocalPart();
                    Map m = (Map)o;
                    if ("values".equals(localPart)) {
                        UIComponentConfiguration uiComponent = (UIComponentConfiguration)ctx.getParentValue();
                        if (m.containsKey("org.jboss.portal.core.identity.locale")) {
                            uiComponent.setPredefinedMapValues("org.jboss.portal.core.identity.locale");
                            m.remove("org.jboss.portal.core.identity.locale");
                        } else if (m.containsKey("org.jboss.portal.core.identity.theme")) {
                            uiComponent.setPredefinedMapValues("org.jboss.portal.core.identity.theme");
                            m.remove("org.jboss.portal.core.identity.theme");
                        } else if (m.containsKey("org.jboss.portal.core.identity.timezone")) {
                            uiComponent.setPredefinedMapValues("org.jboss.portal.core.identity.timezone");
                            m.remove("org.jboss.portal.core.identity.timezone");
                        }
                    }
                    return m;
                }
            };
            TypeBinding vb = schema.getType(new QName("componentValues"));
            vb.setBeforeSetParentCallback(valueCallback);
            Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
            return (IdentityUIConfiguration)unmarshaller.unmarshal(this.getResource(xmlLocation), schema);
        }
        catch (IOException e) {
            throw new CoreIdentityConfigurationException("Could not find configuration file or schema.", e);
        }
        catch (JBossXBException e) {
            throw new CoreIdentityConfigurationException("Could not parse configuration file.", e);
        }
        catch (Throwable e) {
            throw new CoreIdentityConfigurationException("Could not parse configuration file. If you run JBoss Portal with JBoss AS 4.0.5 or minor please check the jboss portal wiki.");
        }
    }

    public boolean isValidConfiguration() throws CoreIdentityConfigurationException {
        if (this.configuration.enableWorkflow()) {
            this.getWorkflowService();
        }
        return true;
    }

    protected InputStream getResource(String path) throws IOException {
        URL url = Thread.currentThread().getContextClassLoader().getResource(path);
        if (url == null) {
            throw new IOException();
        }
        return url.openStream();
    }

    private URL getURL(String path) throws IOException {
        URL url = Thread.currentThread().getContextClassLoader().getResource(path);
        if (url == null) {
            throw new IOException();
        }
        return url;
    }
}

