/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.demo.scheduler.calendar.view.portlet.repository.command;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang.time.DateFormatUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;

public class ReservationListCommand
implements INuxeoCommand {
    private static final String PROCEDURE_REQUEST_FOR_INTERVENTION = "procedure_demande-intervention";
    private NuxeoQueryFilterContext queryContext;
    private final Date startDate;
    private final Date endDate;
    private final String contributor;

    public ReservationListCommand(NuxeoQueryFilterContext queryContext, Date startDate, Date endDate, String contributor) {
        this.queryContext = queryContext;
        this.startDate = startDate;
        this.endDate = endDate;
        this.contributor = contributor;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        this.startDate.setTime(this.startDate.getTime() - 3600000L);
        String start = DateFormatUtils.ISO_DATE_FORMAT.format(this.startDate);
        String end = DateFormatUtils.ISO_DATE_FORMAT.format(this.endDate);
        StringBuilder clause = new StringBuilder();
        clause.append("ecm:primaryType = 'ProcedureInstance' ");
        clause.append("and pi:procedureModelWebId = '").append(PROCEDURE_REQUEST_FOR_INTERVENTION).append("' ");
        clause.append("AND (pi:data/date between DATE '").append(start).append("' and DATE '").append(end).append("') ");
        clause.append("and pi:data/intervenant = '").append(this.contributor).append("' ");
        clause.append("AND (pi:currentStep in ('1','2') OR pi:data/accepted = 'true') ");
        clause.append("ORDER BY pi:data/date ");
        String filteredRequest = NuxeoQueryFilter.addPublicationFilter((NuxeoQueryFilterContext)this.queryContext, (String)clause.toString());
        OperationRequest request = nuxeoSession.newRequest("Document.QueryES");
        request.set("X-NXDocumentProperties", (Object)"*");
        request.set("query", (Object)("SELECT * FROM Document WHERE " + filteredRequest));
        return request.execute();
    }

    public String getId() {
        return "Calendar/" + UUID.randomUUID();
    }
}

