/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.demo.scheduler.plugin.model;

import fr.toutatice.portail.cms.nuxeo.api.portlet.PrivilegedPortletModule;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.time.DateUtils;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

@Component
@Scope(value="prototype")
public class InterventionsListTemplateModule
extends PrivilegedPortletModule {
    private static final String TIMESTAMP_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private final DateFormat timestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private IPortalUrlFactory portalUrlFactory;
    @Autowired
    private IBundleFactory bundleFactory;

    public InterventionsListTemplateModule(PortletContext portletContext) {
        super(portletContext);
    }

    public void doView(RenderRequest request, RenderResponse response, PortletContext portletContext) throws PortletException, IOException {
        String url;
        PortalControllerContext portalControllerContext = new PortalControllerContext(portletContext, (PortletRequest)request, (PortletResponse)response);
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        portletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)this.applicationContext);
        try {
            String instance = "osivia-demo-scheduler-instance";
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("osivia.title", bundle.getString("PLANNING_TITLE"));
            properties.put("theme.dyna.partial_refresh_enabled", String.valueOf(true));
            properties.put("osivia.ajaxLink", "1");
            url = this.portalUrlFactory.getStartPortletUrl(portalControllerContext, instance, properties);
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        request.setAttribute("interventionRequestUrl", (Object)url);
    }

    public int getAuthType() {
        return NuxeoCommandContext.AUTH_TYPE_SUPERUSER;
    }

    public String getFilter(PortalControllerContext portalControllerContext) {
        String user = portalControllerContext.getHttpServletRequest().getRemoteUser();
        Date currentDate = DateUtils.truncate((Date)new Date(), (int)5);
        String timestamp = this.timestampFormat.format(currentDate);
        StringBuilder filter = new StringBuilder();
        filter.append("ecm:primaryType = 'ProcedureInstance' ");
        filter.append("AND pi:procedureModelWebId = 'procedure_demande-intervention' ");
        filter.append("AND pi:procedureInitiator = '").append(user).append("' ");
        filter.append("AND (pi:currentStep in ('1', '2') OR pi:data/accepted = 'true') ");
        filter.append("AND pi:data/date >= TIMESTAMP '").append(timestamp).append("' ");
        return filter.toString();
    }
}

