/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.demo.scheduler.portlet.model;

import org.osivia.portal.api.directory.v2.model.Person;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@Scope(value="prototype")
public class Technician
implements Comparable<Technician> {
    private String id;
    private String text;
    private String givenName;
    private String avatarUrl;
    private String extra;

    public Technician() {
    }

    public Technician(Person person) {
        this.id = person.getUid();
        this.text = StringUtils.isEmpty((Object)person.getDisplayName()) ? person.getUid() : person.getDisplayName();
        this.givenName = person.getGivenName();
        if (person.getAvatar() != null) {
            this.avatarUrl = person.getAvatar().getUrl();
        }
    }

    public Technician(String id) {
        this.id = id;
    }

    @Override
    public int compareTo(Technician arg0) {
        if (this.givenName == null) {
            if (arg0 == null || arg0.givenName == null) {
                return 0;
            }
            return -1;
        }
        if (arg0 == null || arg0.givenName == null) {
            return 1;
        }
        return this.getGivenName().compareTo(arg0.getGivenName());
    }

    public String getText() {
        return this.text;
    }

    public void setText(String displayName) {
        this.text = displayName;
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public String getExtra() {
        return this.extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public String getId() {
        return this.id;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }
}

