/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.demo.scheduler.portlet.repository.command;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;

public class EventListCommand
implements INuxeoCommand {
    private NuxeoQueryFilterContext queryContext;
    private final String contextPath;
    private final String startDate;
    private final String endDate;

    public EventListCommand(NuxeoQueryFilterContext queryContext, String contextPath, String startDate, String endDate) {
        this.queryContext = queryContext;
        this.contextPath = contextPath;
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        StringBuilder clause = new StringBuilder();
        clause.append("ecm:mixinType = 'Schedulable' ");
        clause.append("AND ecm:path STARTSWITH '").append(this.contextPath).append("' ");
        clause.append("AND ((vevent:dtstart < TIMESTAMP '").append(this.endDate).append("') ");
        clause.append("AND (vevent:dtend > TIMESTAMP '").append(this.startDate).append("')) ");
        clause.append(" ORDER BY vevent:dtstart");
        String filteredRequest = NuxeoQueryFilter.addPublicationFilter((NuxeoQueryFilterContext)this.queryContext, (String)clause.toString());
        OperationRequest request = nuxeoSession.newRequest("Document.QueryES");
        request.set("X-NXDocumentProperties", (Object)"dublincore, common, toutatice, vevent");
        request.set("query", (Object)("SELECT * FROM Document WHERE " + filteredRequest));
        return request.execute();
    }

    public String getId() {
        return "Calendar/" + this.contextPath;
    }
}

