/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.demo.scheduler.portlet.service;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCustomizer;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.demo.scheduler.portlet.model.Event;
import org.osivia.demo.scheduler.portlet.model.Reservation;
import org.osivia.demo.scheduler.portlet.model.SchedulerEvent;
import org.osivia.demo.scheduler.portlet.model.SchedulerForm;
import org.osivia.demo.scheduler.portlet.model.SessionInformations;
import org.osivia.demo.scheduler.portlet.model.Technician;
import org.osivia.demo.scheduler.portlet.repository.SchedulerRepository;
import org.osivia.demo.scheduler.portlet.service.SchedulerService;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class SchedulerServiceImpl
implements SchedulerService {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private SchedulerRepository repository;
    @Autowired
    private IPortalUrlFactory portalUrlFactory;
    @Autowired
    private INuxeoService nuxeoService;
    private static final String WEBID = "procedure_demande-intervention";
    private static final String PROCEDURE_PORTLET_INSTANCE = "osivia-services-procedure-portletInstance";
    private static final long TWELVE_HOURS = 43200000L;
    private static final long ONE_DAY = 86400000L;
    private static final long ONE_HOUR = 3600000L;

    public SchedulerForm getForm(PortalControllerContext portalControllerContext) {
        SessionInformations sessionInformations;
        SchedulerForm form = new SchedulerForm();
        String currentUser = portalControllerContext.getHttpServletRequest().getUserPrincipal().getName();
        Object sessionInformationsAttribute = portalControllerContext.getHttpServletRequest().getSession().getAttribute("schedulerDemoInformations");
        if (sessionInformationsAttribute != null && sessionInformationsAttribute instanceof SessionInformations) {
            sessionInformations = (SessionInformations)sessionInformationsAttribute;
        } else {
            sessionInformations = (SessionInformations)this.applicationContext.getBean(SessionInformations.class);
            this.repository.setCustomerInformation(portalControllerContext, sessionInformations, currentUser);
        }
        form.setSessionInformations(sessionInformations);
        sessionInformations.setNeedTimeSlotLoad(sessionInformations.getSelectedContributor() != null);
        return form;
    }

    public List<Technician> loadContributors() {
        List listPerson = this.repository.searchPerson("");
        ArrayList<Technician> listContributor = new ArrayList<Technician>();
        for (Person person : listPerson) {
            Technician contributor = new Technician(person);
            listContributor.add(contributor);
        }
        return listContributor;
    }

    public JSONArray searchContributors(String filter) {
        ArrayList<JSONObject> objects = new ArrayList<JSONObject>();
        List list = this.repository.searchPerson(filter);
        for (Person person : list) {
            objects.add(this.personToJSon(person));
        }
        JSONArray items = new JSONArray();
        items.addAll(objects);
        return items;
    }

    private JSONObject personToJSon(Person person) {
        String extra;
        String displayName;
        JSONObject object = new JSONObject();
        object.put((Object)"id", (Object)person.getUid());
        if (StringUtils.isEmpty((String)person.getDisplayName())) {
            displayName = person.getUid();
            extra = null;
        } else {
            displayName = person.getDisplayName();
            extra = person.getUid();
            if (StringUtils.isNotBlank((String)person.getMail()) && !StringUtils.equals((String)person.getUid(), (String)person.getMail())) {
                extra = extra + " \u2013 " + person.getMail();
            }
        }
        object.put((Object)"text", (Object)displayName);
        object.put((Object)"extra", (Object)extra);
        object.put((Object)"avatar", (Object)person.getAvatar().getUrl());
        object.put((Object)"uid", (Object)person.getUid());
        return object;
    }

    public void loadScheduler(PortalControllerContext portalControllerContext, SchedulerForm form) throws PortletException {
        INuxeoCustomizer cmsCustomizer = this.nuxeoService.getCMSCustomizer();
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
        this.resetAvailability(form);
        Calendar mondayMorning = this.getCalendar(form.getMonday(), 0);
        long milliMondayMorning = mondayMorning.getTimeInMillis();
        Calendar calFridayNight = this.getCalendar(form.getFriday(), 0);
        calFridayNight.add(5, 1);
        long milliFridayNight = calFridayNight.getTimeInMillis();
        String startDate = DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(mondayMorning.getTime());
        String endDate = DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(calFridayNight.getTime());
        HashMap<String, SchedulerEvent> mapDay = new HashMap<String, SchedulerEvent>();
        try {
            List listWorkspaces = cmsCustomizer.getUserWorkspaces(cmsContext, form.getSelectedContributor());
            int start = 0;
            for (Document workspace : listWorkspaces) {
                List events = this.repository.getEvents(portalControllerContext, startDate, endDate, workspace.getPath());
                for (Event event : events) {
                    long milliStart = event.getStartDate().getTime();
                    milliStart = Math.max(milliStart, milliMondayMorning);
                    long milliEnd = event.getEndDate().getTime();
                    milliEnd = Math.min(milliFridayNight, milliEnd);
                    float nb = (float)(milliStart - milliMondayMorning) / 4.32E7f;
                    start = new BigDecimal(nb).setScale(0, RoundingMode.DOWN).intValue();
                    this.timeSlot(start, milliMondayMorning, milliEnd, mapDay);
                }
            }
        }
        catch (CMSException e) {
            throw new PortletException((Throwable)e);
        }
        mondayMorning.setTimeInMillis(mondayMorning.getTimeInMillis() - 3600000L);
        startDate = DateFormatUtils.ISO_DATE_FORMAT.format(mondayMorning.getTime());
        endDate = DateFormatUtils.ISO_DATE_FORMAT.format(calFridayNight.getTime());
        List reservations = this.repository.getReservations(portalControllerContext, startDate, endDate, form.getSelectedContributor(), form.getCustomerUsers());
        for (Reservation reservation : reservations) {
            float nbMillis = Math.abs((float)(reservation.getDay().getTime() - milliMondayMorning));
            int nbDays = new BigDecimal(nbMillis / 8.64E7f).setScale(0, 4).intValue();
            int nbHalfDays = nbDays * 2 + ("PM".equals(reservation.getTimeSlot()) ? 1 : 0);
            SchedulerEvent schedulerEvent = new SchedulerEvent(true);
            schedulerEvent.setTitle(reservation.getTitle());
            schedulerEvent.setComment(reservation.getComment());
            schedulerEvent.setAccepted(reservation.isAccepted());
            schedulerEvent.setCreator(reservation.getCreatorName());
            schedulerEvent.setDateCreationReservation(reservation.getDateCreationReservation());
            if (form.getCustomerUsers() != null && form.getCustomerUsers().contains(reservation.getCreatorId())) {
                mapDay.put(Integer.toString(nbHalfDays), schedulerEvent);
                continue;
            }
            schedulerEvent.setReservation(false);
            mapDay.put(Integer.toString(nbHalfDays), schedulerEvent);
        }
        this.setBusyTimeSlot(form, mapDay);
    }

    private void timeSlot(int start, long milliMondayMorning, long milliEnd, Map<String, SchedulerEvent> mapDay) {
        float nb = (float)(milliEnd - milliMondayMorning) / 4.32E7f;
        BigDecimal halfDay = new BigDecimal(nb).setScale(0, RoundingMode.UP);
        int nbHalfDay = halfDay.intValue() - start;
        SchedulerEvent schedulerEvent = new SchedulerEvent(false);
        for (int i = 0; i < nbHalfDay; ++i) {
            mapDay.put(Integer.toString(i + start), schedulerEvent);
        }
    }

    private Calendar getCalendar(Date startDate, int hourOfDay) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        calendar.set(11, hourOfDay);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    private void setBusyTimeSlot(SchedulerForm form, Map<String, SchedulerEvent> mapDay) {
        if (mapDay.get("0") != null) {
            form.getTimeSlots()[0] = mapDay.get("0");
        }
        if (mapDay.get("2") != null) {
            form.getTimeSlots()[1] = mapDay.get("2");
        }
        if (mapDay.get("4") != null) {
            form.getTimeSlots()[2] = mapDay.get("4");
        }
        if (mapDay.get("6") != null) {
            form.getTimeSlots()[3] = mapDay.get("6");
        }
        if (mapDay.get("8") != null) {
            form.getTimeSlots()[4] = mapDay.get("8");
        }
        if (mapDay.get("1") != null) {
            form.getTimeSlots()[5] = mapDay.get("1");
        }
        if (mapDay.get("3") != null) {
            form.getTimeSlots()[6] = mapDay.get("3");
        }
        if (mapDay.get("5") != null) {
            form.getTimeSlots()[7] = mapDay.get("5");
        }
        if (mapDay.get("7") != null) {
            form.getTimeSlots()[8] = mapDay.get("7");
        }
        if (mapDay.get("9") != null) {
            form.getTimeSlots()[9] = mapDay.get("9");
        }
    }

    private void resetAvailability(SchedulerForm form) {
        form.setTimeSlots(new SchedulerEvent[10]);
    }

    public void startContribution(PortalControllerContext portalControllerContext, String selectedContributor, String selectedDay, String selectedHalfDay) throws PortletException, IOException {
        String url;
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.services.procedure.webid", WEBID);
        windowProperties.put("osivia.doctype", "ProcedureModel");
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "true");
        windowProperties.put("osivia.ajaxLink", "1");
        JSONObject variables = new JSONObject();
        variables.put((Object)"intervenant", (Object)selectedContributor);
        variables.put((Object)"date", (Object)selectedDay);
        variables.put((Object)"plage", (Object)selectedHalfDay);
        windowProperties.put("osivia.services.procedure.variables", variables.toString());
        try {
            url = this.portalUrlFactory.getStartPortletUrl(portalControllerContext, PROCEDURE_PORTLET_INSTANCE, windowProperties);
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        ActionResponse response = (ActionResponse)portalControllerContext.getResponse();
        response.sendRedirect(url);
    }
}

